import Mock from 'mockjs';

Mock.setup({
    timeout: '200-1200',
});

// /system/version
Mock.mock(/\/system\/version/, {
    message: 'success',
    result: {
        edition: 'community',
        version: '2.0.0-SNAPSHOT',
    },
    status: 200,
    timestamp: 1687270877560,
});

// /authorize/captcha/config
Mock.mock(/\/authorize\/captcha\/config/, {
  "message": "success",
  "result": {
      "enabled": false,
      "type": "image"
  },
  "status": 200,
  "timestamp": 1687270902842
});

// /authorize/login
Mock.mock(/\/authorize\/login/, {
  "message": "success",
  "result": {
      "expires": 3600000,
      "permissions": [],
      "roles": [
          {
              "id": "1199596756811550720",
              "username": "admin",
              "name": "超级管理员",
              "userType": "normal",
              "type": "user"
          }
      ],
      "userId": "1199596756811550720",
      "user": {
          "id": "1199596756811550720",
          "username": "admin",
          "type": "normal",
          "status": 1,
          "name": "超级管理员",
          "createTime": 0,
          "roleList": [],
          "orgList": [],
          "institutionList": [],
          "tenantDisabled": false
      },
      "currentAuthority": [],
      "token": "d60faa6b06cc113dfecb075ae766b69e"
  },
  "status": 200,
  "timestamp": 1687271348733
});

// /user-token/reset
Mock.mock(/\/user-token\/reset/, {"message":"success","result":true,"status":200,"timestamp":1687271846106});

// /user/settings/init
Mock.mock(/\/user\/settings\/init/, {
  "message": "success",
  "result": [
      {
          "id": "b61c4ecca1139ea7a580fed52875ec8c",
          "userId": "1199596756811550720",
          "type": "init",
          "key": "d30ac8b40966f4abc8cc5a77dbed04dd",
          "createTime": 1670998784416
      }
  ],
  "status": 200,
  "timestamp": 1687271349803
});

// /notifications/_query
Mock.mock(/\/notifications\/_query/, {
  "message": "success",
  "result": {
      "pageIndex": 0,
      "pageSize": 25,
      "total": 0,
      "data": []
  },
  "status": 200,
  "timestamp": 1687270971612
});

// /user/detail
Mock.mock(/\/user\/detail/, {
  "message": "success",
  "result": {
      "id": "1199596756811550720",
      "username": "admin",
      "type": "normal",
      "status": 1,
      "name": "超级管理员",
      "createTime": 0,
      "roleList": [],
      "orgList": [],
      "institutionList": [],
      "tenantDisabled": false
  },
  "status": 200,
  "timestamp": 1687270959640
});

// /system/config/scopes
Mock.mock(/\/system\/config\/scopes/, {
  "message": "success",
  "result": [
      {
          "scope": "front",
          "properties": {
              "title": "档案库房智慧监测统一管理平台",
              "headerTheme": "dark",
              "logo": "http://140.210.194.126:9000/logo.png",
              "ico": "http://localhost:8848/upload/20230524/1661358108200824832.ico",
              "backgroud": "/static/login.eeb5d861.png",
              "apiKey": "",
              "base-path": ""
          }
      },
      {
          "scope": "amap",
          "properties": {
              "api": ""
          }
      },
      {
          "scope": "paths",
          "properties": {
              "base-path": "http://10.1.1.109:8848"
          }
      }
  ],
  "status": 200,
  "timestamp": 1687271502860
});

// /menu/user-own/tree
Mock.mock(/\/menu\/user-own\/tree/, {
    "message": "success",
    "result": [
      {
        "id": "9c21f88182e7cc75cbdfa8e4b7844272",
        "path": "4o6S",
        "sortIndex": 1,
        "level": 1,
        "owner": "iot",
        "name": "管理平台",
        "code": "iot",
        "icon": "icon-wulianwang",
        "url": "/iot",
        "children": [
          {
            "id": "1665017774862524416",
            "parentId": "9c21f88182e7cc75cbdfa8e4b7844272",
            "path": "4o6S-jPDk",
            "sortIndex": 10,
            "level": 2,
            "owner": "iot",
            "name": "工作台",
            "code": "home",
            "icon": "BankOutlined",
            "url": "/home",
            "createTime": 1685806146590,
            "granted": true
          },
          {
            "id": "1660190820672331776",
            "parentId": "9c21f88182e7cc75cbdfa8e4b7844272",
            "path": "4o6S-cFeh",
            "sortIndex": 15,
            "level": 2,
            "owner": "iot",
            "name": "设备监测",
            "code": "device-overview",
            "icon": "SecurityScanOutlined",
            "url": "/device-overview",
            "createTime": 1684655311070,
            "granted": true
          },
          {
            "id": "1665037543946870784",
            "parentId": "9c21f88182e7cc75cbdfa8e4b7844272",
            "path": "4o6S-jqa4",
            "sortIndex": 20,
            "level": 2,
            "owner": "iot",
            "name": "设备管理",
            "code": "device-manager",
            "icon": "ContainerOutlined",
            "url": "/device-manager",
            "children": [
              {
                "id": "1665037965667360768",
                "parentId": "1665037543946870784",
                "path": "4o6S-jqa4-XypD",
                "sortIndex": 1,
                "level": 3,
                "owner": "iot",
                "name": "设备列表",
                "code": "device-manager/list",
                "icon": "InsertRowAboveOutlined",
                "url": "/device-manager/list",
                "createTime": 1685810960495,
                "granted": true
              },
              {
                "id": "1660187655591813120",
                "parentId": "1665037543946870784",
                "path": "4o6S-jqa4-OCXd",
                "sortIndex": 3,
                "level": 3,
                "owner": "iot",
                "name": "密集架管理",
                "code": "device-manager/mjg",
                "icon": "MinusSquareOutlined",
                "url": "/device-manager/mjg",
                "createTime": 1684654556435,
                "granted": true
              }
            ],
            "createTime": 1685810859947,
            "granted": true
          },
          {
            "id": "1665029712757678080",
            "parentId": "9c21f88182e7cc75cbdfa8e4b7844272",
            "path": "4o6S-Ajle",
            "sortIndex": 25,
            "level": 2,
            "owner": "iot",
            "name": "设备告警",
            "code": "device-warning",
            "icon": "ExclamationCircleOutlined",
            "url": "/device-warning",
            "createTime": 1685808992850,
            "granted": true
          },
          {
            "id": "1665030877817888768",
            "parentId": "9c21f88182e7cc75cbdfa8e4b7844272",
            "path": "4o6S-RLKO",
            "sortIndex": 30,
            "level": 2,
            "owner": "iot",
            "name": "设备巡检",
            "code": "device-inspection",
            "icon": "MonitorOutlined",
            "url": "/device-inspection",
            "children": [
              {
                "id": "1665031795602907136",
                "parentId": "1665030877817888768",
                "path": "4o6S-RLKO-lwuo",
                "sortIndex": 10,
                "level": 3,
                "owner": "iot",
                "name": "智能巡检",
                "code": "device-inspection/exec",
                "icon": "ToolOutlined",
                "url": "/device-inspection/exec",
                "createTime": 1685809489408,
                "granted": true
              },
              {
                "id": "1665032085475450880",
                "parentId": "1665030877817888768",
                "path": "4o6S-RLKO-Zj5f",
                "sortIndex": 20,
                "level": 3,
                "owner": "iot",
                "name": "巡检计划",
                "code": "device-inspection/plan",
                "icon": "CalendarOutlined",
                "url": "/device-inspection/plan",
                "createTime": 1685809558521,
                "granted": true
              }
            ],
            "createTime": 1685809270655,
            "granted": true
          },
          {
            "id": "1659560098398945280",
            "parentId": "9c21f88182e7cc75cbdfa8e4b7844272",
            "path": "4o6S-xpkO",
            "sortIndex": 35,
            "level": 1,
            "owner": "iot",
            "name": "全网监测",
            "code": "whole",
            "icon": "GlobalOutlined",
            "url": "/whole",
            "children": [
              {
                "id": "1659562111861997568",
                "parentId": "1659560098398945280",
                "path": "fdbH-2J6G",
                "sortIndex": 1,
                "level": 2,
                "owner": "iot",
                "name": "下级监测",
                "code": "whole/region-view",
                "icon": "DotChartOutlined",
                "url": "/whole/region-view",
                "createTime": 1684505415180,
                "granted": true
              },
              {
                "id": "1659562832397287424",
                "parentId": "1659560098398945280",
                "path": "fdbH-RTWP",
                "sortIndex": 2,
                "level": 2,
                "owner": "iot",
                "name": "运行监测",
                "code": "whole/insitution-view",
                "icon": "CheckSquareOutlined",
                "url": "/whole/institution-view",
                "createTime": 1684505586970,
                "granted": true
              }
            ],
            "createTime": 1685805899329,
            "granted": true
          },
          {
            "id": "1665032797613744128",
            "parentId": "9c21f88182e7cc75cbdfa8e4b7844272",
            "path": "4o6S-lBYG",
            "sortIndex": 40,
            "level": 2,
            "owner": "iot",
            "name": "数据报表",
            "code": "data-report",
            "icon": "RiseOutlined",
            "url": "/data-report",
            "children": [
              {
                "id": "1665033350494314496",
                "parentId": "1665032797613744128",
                "path": "4o6S-lBYG-xolT",
                "sortIndex": 1,
                "level": 3,
                "owner": "iot",
                "name": "告警统计",
                "code": "data-report/warning",
                "icon": "ExceptionOutlined",
                "url": "/data-report/warning",
                "createTime": 1685809860122,
                "granted": true
              },
              {
                "id": "1665033627347738624",
                "parentId": "1665032797613744128",
                "path": "4o6S-lBYG-WaNg",
                "sortIndex": 2,
                "level": 3,
                "owner": "iot",
                "name": "设备统计",
                "code": "data-report/device",
                "icon": "BarcodeOutlined",
                "url": "/data-report/device",
                "createTime": 1685809926129,
                "granted": true
              },
              {
                "id": "1665034053388361728",
                "parentId": "1665032797613744128",
                "path": "4o6S-lBYG-ku6k",
                "sortIndex": 3,
                "level": 3,
                "owner": "iot",
                "name": "运行参数报表",
                "code": "data-report/runparam",
                "icon": "BarChartOutlined",
                "url": "/data-report/runparam",
                "createTime": 1685810027706,
                "granted": true
              },
              {
                "id": "1665034452241506304",
                "parentId": "1665032797613744128",
                "path": "4o6S-lBYG-XHFC",
                "sortIndex": 4,
                "level": 3,
                "owner": "iot",
                "name": "设备监测报表",
                "code": "data-report/monitor",
                "icon": "CodepenOutlined",
                "url": "/data-report/monitor",
                "createTime": 1685810122799,
                "granted": true
              }
            ],
            "createTime": 1685809728306,
            "granted": true
          },
          {
            "id": "1665034819872251904",
            "parentId": "9c21f88182e7cc75cbdfa8e4b7844272",
            "path": "4o6S-rkGF",
            "sortIndex": 50,
            "level": 2,
            "owner": "iot",
            "name": "数据大屏",
            "code": "data-screen",
            "icon": "AliyunOutlined",
            "url": "/data-screen",
            "createTime": 1685810210448,
            "granted": true
          }
        ],
        "createTime": 1685805899316,
        "granted": true
      },
      {
        "id": "1659567139146383360",
        "path": "lhY6",
        "sortIndex": 2,
        "level": 1,
        "owner": "iot",
        "name": "配置管理",
        "code": "cfg",
        "icon": "SettingOutlined",
        "url": "/cfg",
        "children": [
          {
            "id": "b6327c3ff01b49c9a7a96101606dc27a",
            "parentId": "1659567139146383360",
            "path": "4o6S-He3C",
            "sortIndex": 10,
            "level": 2,
            "owner": "iot",
            "name": "产品配置",
            "code": "device",
            "icon": "icon-shebei",
            "url": "/iot/device",
            "children": [
              {
                "id": "68a02c9efa9fb4885c89b007f97d074d",
                "parentId": "b6327c3ff01b49c9a7a96101606dc27a",
                "path": "4o6S-He3C-iTxH",
                "sortIndex": 0,
                "level": 3,
                "owner": "iot",
                "name": "仪表盘",
                "code": "device/DashBoard",
                "icon": "icon-keshihua",
                "url": "/iot/device/DashBoard",
                "createTime": 1684981409173,
                "granted": true
              },
              {
                "id": "8ddbb67de5f65514105d47b448bfd70e",
                "parentId": "b6327c3ff01b49c9a7a96101606dc27a",
                "path": "4o6S-He3C-MRmD",
                "sortIndex": 1,
                "level": 3,
                "owner": "iot",
                "name": "产品",
                "code": "device/Product",
                "icon": "icon-chanpin",
                "url": "/iot/device/Product",
                "buttons": [
                  { "id": "view", "name": "查看", "enabled": false, "granted": true },
                  { "id": "update", "name": "编辑", "enabled": false, "granted": true },
                  { "id": "action", "name": "启/禁用", "enabled": false, "granted": true },
                  { "id": "export", "name": "导出", "enabled": false, "granted": true },
                  { "id": "import", "name": "导入", "enabled": false, "granted": true },
                  { "id": "delete", "name": "删除", "enabled": false, "granted": true },
                  { "id": "add", "name": "新增", "enabled": false, "granted": true }
                ],
                "createTime": 1684981409173,
                "granted": true
              },
              {
                "id": "1b136e7e4e4e74bb24b91802e4cfcd2d",
                "parentId": "b6327c3ff01b49c9a7a96101606dc27a",
                "path": "4o6S-He3C-DNeR",
                "sortIndex": 2,
                "level": 3,
                "owner": "iot",
                "name": "设备",
                "code": "device/Instance",
                "icon": "icon-shebei",
                "url": "/iot/device/Instance",
                "buttons": [
                  { "id": "view", "name": "查看", "enabled": false, "granted": true },
                  { "id": "export", "name": "导出", "enabled": false, "granted": true },
                  { "id": "import", "name": "导入", "enabled": false, "granted": true },
                  { "id": "update", "name": "编辑", "enabled": false, "granted": true },
                  { "id": "action", "name": "启/禁用", "enabled": false, "granted": true },
                  { "id": "delete", "name": "删除", "enabled": false, "granted": true },
                  { "id": "add", "name": "新增", "enabled": false, "granted": true }
                ],
                "createTime": 1684981409173,
                "granted": true
              },
              {
                "id": "bc83f18659982abb9ac1a96362fc3372",
                "parentId": "b6327c3ff01b49c9a7a96101606dc27a",
                "path": "4o6S-He3C-kHT3",
                "sortIndex": 3,
                "level": 3,
                "owner": "iot",
                "name": "产品分类",
                "code": "device/Category",
                "icon": "icon-chanpinfenlei",
                "url": "/iot/device/Category",
                "buttons": [
                  { "id": "view", "name": "查看", "enabled": false, "granted": true },
                  { "id": "delete", "name": "删除", "enabled": false, "granted": true },
                  { "id": "update", "name": "编辑", "enabled": false, "granted": true },
                  { "id": "add", "name": "新增", "enabled": false, "granted": true }
                ],
                "createTime": 1684981409173,
                "granted": true
              }
            ],
            "createTime": 1684981409173,
            "granted": true
          },
          {
            "id": "bd55cdc9d0c1700afe628f572f91c22e",
            "parentId": "1659567139146383360",
            "path": "4o6S-hWe6",
            "sortIndex": 20,
            "level": 2,
            "owner": "iot",
            "name": "设备接入",
            "code": "link",
            "icon": "icon-yunweiguanli-1",
            "url": "/iot/link",
            "children": [
              {
                "id": "47bedff9df89ecc0f0ce896e53805f02",
                "parentId": "bd55cdc9d0c1700afe628f572f91c22e",
                "path": "4o6S-hWe6-mvqc",
                "sortIndex": 0,
                "level": 3,
                "owner": "iot",
                "name": "仪表盘",
                "code": "link/DashBoard",
                "icon": "icon-keshihua",
                "url": "/iot/link/dashboard",
                "createTime": 1684981409173,
                "granted": true
              },
              {
                "id": "10e67b761ec1f4206fabf36fcf9d9b0b",
                "parentId": "bd55cdc9d0c1700afe628f572f91c22e",
                "path": "4o6S-hWe6-qbrQ",
                "sortIndex": 1,
                "level": 3,
                "owner": "iot",
                "name": "设备接入网关",
                "code": "link/AccessConfig",
                "icon": "icon-wangguanzishebei",
                "url": "/iot/link/accessConfig",
                "buttons": [
                  { "id": "view", "name": "查看", "enabled": false, "granted": true },
                  { "id": "delete", "name": "删除", "enabled": false, "granted": true },
                  { "id": "action", "name": "启/禁用", "enabled": false, "granted": true },
                  { "id": "add", "name": "新增", "enabled": false, "granted": true },
                  { "id": "update", "name": "编辑", "enabled": false, "granted": true }
                ],
                "createTime": 1684981409173,
                "granted": true
              },
              {
                "id": "cdd73c8cb02d1ae9af61ded7fc31e9c5",
                "parentId": "bd55cdc9d0c1700afe628f572f91c22e",
                "path": "4o6S-hWe6-3LMf",
                "sortIndex": 2,
                "level": 3,
                "owner": "iot",
                "name": "协议管理",
                "code": "link/Protocol",
                "icon": "icon-tongzhiguanli",
                "url": "/iot/link/protocol",
                "buttons": [
                  { "id": "view", "name": "查看", "enabled": false, "granted": true },
                  { "id": "delete", "name": "删除", "enabled": false, "granted": true },
                  { "id": "update", "name": "编辑", "enabled": false, "granted": true },
                  { "id": "add", "name": "新增", "enabled": false, "granted": true }
                ],
                "createTime": 1684981409173,
                "granted": true
              },
              {
                "id": "c340f8977e0d221da893715cab58ae8c",
                "parentId": "bd55cdc9d0c1700afe628f572f91c22e",
                "path": "4o6S-hWe6-oieX",
                "sortIndex": 3,
                "level": 3,
                "owner": "iot",
                "name": "日志管理",
                "code": "Log",
                "icon": "icon-rizhifuwu",
                "url": "/iot/link/Log",
                "buttons": [],
                "createTime": 1684981409173,
                "granted": true
              },
              {
                "id": "f99acd0b64f96209eb276236cfb427cb",
                "parentId": "bd55cdc9d0c1700afe628f572f91c22e",
                "path": "4o6S-hWe6-qePq",
                "sortIndex": 4,
                "level": 3,
                "owner": "iot",
                "name": "网络组件",
                "code": "link/Type",
                "icon": "icon-wangluozujian",
                "url": "/iot/link/type",
                "buttons": [
                  { "id": "view", "name": "查看", "enabled": false, "granted": true },
                  { "id": "action", "name": "启/禁用", "enabled": false, "granted": true },
                  { "id": "delete", "name": "删除", "enabled": false, "granted": true },
                  { "id": "add", "name": "新增", "enabled": false, "granted": true },
                  { "id": "update", "name": "编辑", "enabled": false, "granted": true }
                ],
                "createTime": 1684981409173,
                "granted": true
              },
              {
                "id": "e395655a273a1b765236342738289587",
                "parentId": "bd55cdc9d0c1700afe628f572f91c22e",
                "path": "4o6S-hWe6-j3gB",
                "sortIndex": 5,
                "level": 3,
                "owner": "iot",
                "name": "证书管理",
                "code": "link/Certificate",
                "icon": "icon-zhengshuguanli",
                "url": "/iot/link/Certificate",
                "buttons": [
                  { "id": "delete", "name": "删除", "enabled": false, "granted": true },
                  { "id": "update", "name": "编辑", "enabled": false, "granted": true },
                  { "id": "add", "name": "新增", "enabled": false, "granted": true },
                  { "id": "view", "name": "查看", "enabled": false, "granted": true }
                ],
                "createTime": 1684981409173,
                "granted": true
              }
            ],
            "createTime": 1684981409173,
            "granted": true
          },
          {
            "id": "91aa7c753b1c030dfad612aa0a45d453",
            "parentId": "1659567139146383360",
            "path": "4o6S-hvwo",
            "sortIndex": 30,
            "level": 2,
            "owner": "iot",
            "name": "规则管理",
            "code": "rule-engine",
            "icon": "icon-zidingyiguize",
            "url": "/iot/rule-engine",
            "buttons": [],
            "children": [
              {
                "id": "b68867fdc24cfc3df7c52e842136f439",
                "parentId": "91aa7c753b1c030dfad612aa0a45d453",
                "path": "4o6S-hvwo-RjYL",
                "sortIndex": 0,
                "level": 3,
                "owner": "iot",
                "name": "场景联动",
                "code": "rule-engine/Scene",
                "icon": "icon-yunweiguanli-1",
                "url": "/iot/rule-engine/scene",
                "buttons": [
                  { "id": "delete", "name": "删除", "enabled": false, "granted": true },
                  { "id": "tigger", "name": "手动触发", "enabled": false, "granted": true },
                  { "id": "view", "name": "查看", "enabled": false, "granted": true },
                  { "id": "action", "name": "启用/禁用", "enabled": false, "granted": true },
                  { "id": "add", "name": "新增", "enabled": false, "granted": true },
                  { "id": "update", "name": "编辑", "enabled": false, "granted": true }
                ],
                "createTime": 1684981409173,
                "granted": true
              }
            ],
            "createTime": 1684981409173,
            "granted": true
          },
          {
            "id": "3c7dca6ea8b5828bbcc023ce905244f7",
            "parentId": "1659567139146383360",
            "path": "lhY6-Vl9s",
            "sortIndex": 40,
            "level": 2,
            "owner": "iot",
            "name": "告警基础配置",
            "code": "rule-engine/Alarm",
            "icon": "icon-shebeigaojing",
            "url": "/iot/Alarm",
            "buttons": [],
            "children": [
              {
                "id": "f4d6880e3d8b3e3234c547fa84856b32",
                "parentId": "3c7dca6ea8b5828bbcc023ce905244f7",
                "path": "lhY6-Vl9s-c1Ii",
                "sortIndex": 0,
                "level": 3,
                "owner": "iot",
                "name": "仪表盘",
                "code": "rule-engine/DashBoard",
                "icon": "icon-keshihua",
                "url": "/iot/Alarm/dashboard",
                "buttons": [],
                "createTime": 1684654670776,
                "granted": true
              },
              {
                "id": "af160284d1934bf052a2eeb9b9a9cb8f",
                "parentId": "3c7dca6ea8b5828bbcc023ce905244f7",
                "path": "lhY6-Vl9s-Js1n",
                "sortIndex": 1,
                "level": 3,
                "owner": "iot",
                "name": "基础配置",
                "code": "rule-engine/Alarm/Config",
                "icon": "icon-chajianguanli",
                "url": "/iot/Alarm/Config",
                "buttons": [{ "id": "update", "name": "保存", "enabled": false, "granted": true }],
                "createTime": 1684654670776,
                "granted": true
              },
              {
                "id": "c5d3b1261f2f414dd04b0bf9194aa29e",
                "parentId": "3c7dca6ea8b5828bbcc023ce905244f7",
                "path": "lhY6-Vl9s-MRvh",
                "sortIndex": 2,
                "level": 3,
                "owner": "iot",
                "name": "告警配置",
                "code": "rule-engine/Alarm/Configuration",
                "icon": "icon-warning_amber",
                "url": "/iot/Alarm/Configuration",
                "buttons": [
                  { "id": "view", "name": "查看", "enabled": false, "granted": true },
                  { "id": "add", "name": "新增", "enabled": false, "granted": true },
                  { "id": "action", "name": "启/禁用", "enabled": false, "granted": true },
                  { "id": "delete", "name": "删除", "enabled": false, "granted": true },
                  { "id": "update", "name": "编辑", "enabled": false, "granted": true },
                  { "id": "tigger", "name": "手动触发", "enabled": false, "granted": true }
                ],
                "createTime": 1684654670776,
                "granted": true
              },
              {
                "id": "fca24d8d3276a410f7031a9b721017fd",
                "parentId": "3c7dca6ea8b5828bbcc023ce905244f7",
                "path": "lhY6-Vl9s-G7xT",
                "sortIndex": 3,
                "level": 3,
                "owner": "iot",
                "name": "告警记录",
                "code": "rule-engine/Alarm/Log",
                "icon": "icon-changjingliandong",
                "url": "/iot/Alarm/Log",
                "buttons": [
                  { "id": "view", "name": "查看", "enabled": false, "granted": true },
                  { "id": "action", "name": "告警处理", "enabled": false, "granted": true }
                ],
                "createTime": 1684654670776,
                "granted": true
              }
            ],
            "createTime": 1684654670776,
            "granted": true
          },
          {
            "id": "1659554746106331136",
            "parentId": "1659567139146383360",
            "path": "4o6S-zvBy",
            "sortIndex": 50,
            "level": 2,
            "owner": "iot",
            "name": "库房管理",
            "code": "warehouse",
            "icon": "PicCenterOutlined",
            "url": "/warehouse",
            "children": [
              {
                "id": "1659555280792010752",
                "parentId": "1659554746106331136",
                "path": "4o6S-zvBy-fbM3",
                "sortIndex": 0,
                "level": 3,
                "owner": "iot",
                "name": "行政区域",
                "code": "warehouse/region",
                "icon": "RadarChartOutlined",
                "url": "/warehouse/region",
                "createTime": 1684503786523,
                "granted": true
              },
              {
                "id": "1659556329556754432",
                "parentId": "1659554746106331136",
                "path": "4o6S-zvBy-WdEN",
                "sortIndex": 1,
                "level": 3,
                "owner": "iot",
                "name": "单位管理",
                "code": "warehouse/institution",
                "icon": "HeatMapOutlined",
                "url": "/warehouse/institution",
                "createTime": 1684504036572,
                "granted": true
              },
              {
                "id": "1659556927949717504",
                "parentId": "1659554746106331136",
                "path": "4o6S-zvBy-ZKqF",
                "sortIndex": 2,
                "level": 3,
                "owner": "iot",
                "name": "库房管理",
                "code": "warehouse/store",
                "icon": "CopyOutlined",
                "url": "/warehouse/store",
                "createTime": 1684504179239,
                "granted": true
              }
            ],
            "createTime": 1684503659083,
            "granted": true
          },
          {
            "id": "b27e972543cdc5da5730b6d4b9b537b1",
            "parentId": "1659567139146383360",
            "path": "lhY6-hZIq",
            "sortIndex": 60,
            "level": 2,
            "owner": "iot",
            "name": "通知管理",
            "code": "notice",
            "icon": "icon-tongzhiguanli",
            "url": "/iot/notice",
            "children": [
              {
                "id": "09bcab0a6a1f0796075254a453139287",
                "parentId": "b27e972543cdc5da5730b6d4b9b537b1",
                "path": "lhY6-hZIq-EqOz",
                "sortIndex": 0,
                "level": 3,
                "owner": "iot",
                "name": "通知配置",
                "code": "notice/Config",
                "icon": "icon-tongzhiguanli",
                "url": "/iot/notice/Config",
                "buttons": [
                  { "id": "bind", "name": "同步用户", "enabled": false, "granted": true },
                  { "id": "view", "name": "查看", "enabled": false, "granted": true },
                  { "id": "log", "name": "通知记录", "enabled": false, "granted": true },
                  { "id": "debug", "name": "调试", "enabled": false, "granted": true },
                  { "id": "export", "name": "导出", "enabled": false, "granted": true },
                  { "id": "import", "name": "导入", "enabled": false, "granted": true },
                  { "id": "delete", "name": "删除", "enabled": false, "granted": true },
                  { "id": "update", "name": "编辑", "enabled": false, "granted": true },
                  { "id": "add", "name": "新增", "enabled": false, "granted": true }
                ],
                "createTime": 1684654670776,
                "granted": true
              },
              {
                "id": "705b82c807fa18360bf62a2b35f454e9",
                "parentId": "b27e972543cdc5da5730b6d4b9b537b1",
                "path": "lhY6-hZIq-v79X",
                "sortIndex": 1,
                "level": 3,
                "owner": "iot",
                "name": "通知模板",
                "code": "notice/Template",
                "icon": "icon-tongzhiguanli",
                "url": "/iot/notice/Template",
                "buttons": [
                  { "id": "view", "name": "查看", "enabled": false, "granted": true },
                  { "id": "log", "name": "通知记录", "enabled": false, "granted": true },
                  { "id": "debug", "name": "调试", "enabled": false, "granted": true },
                  { "id": "export", "name": "导出", "enabled": false, "granted": true },
                  { "id": "import", "name": "导入", "enabled": false, "granted": true },
                  { "id": "delete", "name": "删除", "enabled": false, "granted": true },
                  { "id": "update", "name": "编辑", "enabled": false, "granted": true },
                  { "id": "add", "name": "新增", "enabled": false, "granted": true }
                ],
                "createTime": 1684654670776,
                "granted": true
              }
            ],
            "createTime": 1684654670776,
            "granted": true
          },
          {
            "id": "1660188628594843648",
            "parentId": "1659567139146383360",
            "path": "4o6S-nPYU",
            "sortIndex": 70,
            "level": 2,
            "owner": "iot",
            "name": "视频设备",
            "code": "iot/video",
            "icon": "CaretRightOutlined",
            "url": "/iot/video",
            "children": [
              {
                "id": "1661309692709482496",
                "parentId": "1660188628594843648",
                "path": "4o6S-nPYU-dLQ9",
                "sortIndex": 0,
                "level": 3,
                "owner": "iot",
                "name": "视频目录管理",
                "code": "iot/video/category",
                "icon": "AppstoreAddOutlined",
                "url": "/iot/video",
                "createTime": 1684922070932,
                "granted": true
              },
              {
                "id": "1661310486187913216",
                "parentId": "1660188628594843648",
                "path": "4o6S-nPYU-3sf8",
                "sortIndex": 1,
                "level": 3,
                "owner": "iot",
                "name": "监控点位配置",
                "code": "iot/video/mpoint",
                "icon": "EyeFilled",
                "url": "/iot/video/mpoint",
                "createTime": 1684922260138,
                "granted": true
              }
            ],
            "createTime": 1684654788430,
            "granted": true
          }
        ],
        "createTime": 1685805899327,
        "granted": true
      },
      {
        "id": "fd1670b860ae58cc58bcd01d027ccd35",
        "path": "qpew",
        "sortIndex": 4,
        "level": 1,
        "owner": "iot",
        "name": "系统管理",
        "code": "system",
        "icon": "icon-xitongguanli1",
        "url": "/system",
        "buttons": [],
        "children": [
          {
            "id": "96e4bd287adbe0486e2168c59450841f",
            "parentId": "fd1670b860ae58cc58bcd01d027ccd35",
            "path": "qpew-foVo",
            "sortIndex": 0,
            "level": 2,
            "owner": "iot",
            "name": "基础配置",
            "code": "system/Basis",
            "icon": "icon-shezhi",
            "url": "/system/Basis",
            "buttons": [
              { "id": "view", "name": "查看", "enabled": false, "granted": true },
              { "id": "update", "name": "保存", "enabled": false, "granted": true }
            ],
            "createTime": 1684981409173,
            "granted": true
          },
          {
            "id": "fe2e557bcf09a5503cbb5bebeb0b7f1c",
            "parentId": "fd1670b860ae58cc58bcd01d027ccd35",
            "path": "qpew-q6lw",
            "sortIndex": 1,
            "level": 2,
            "owner": "iot",
            "name": "用户管理",
            "code": "system/User",
            "icon": "icon-yonghuguanli",
            "url": "/system/user",
            "buttons": [
              { "id": "view", "name": "查看", "enabled": false, "granted": true },
              { "id": "action", "name": "启/禁用", "enabled": false, "granted": true },
              { "id": "delete", "name": "删除", "enabled": false, "granted": true },
              { "id": "update", "name": "编辑", "enabled": false, "granted": true },
              { "id": "add", "name": "新增", "enabled": false, "granted": true }
            ],
            "createTime": 1684981409173,
            "granted": true
          },
          {
            "id": "3962ec0835f3b4a68c1f63b955625046",
            "parentId": "fd1670b860ae58cc58bcd01d027ccd35",
            "path": "qpew-Q1T0",
            "sortIndex": 2,
            "level": 2,
            "owner": "iot",
            "name": "组织管理",
            "code": "system/Department",
            "icon": "icon-bumenguanli",
            "url": "/system/Department",
            "buttons": [
              { "id": "view", "name": "查看", "enabled": false, "granted": true },
              { "id": "bind", "name": "资产解绑", "enabled": false, "granted": true },
              { "id": "bind-user", "name": "绑定用户", "enabled": false, "granted": true },
              { "id": "assert", "name": "资产分配", "enabled": false, "granted": true },
              { "id": "delete", "name": "删除", "enabled": false, "granted": true },
              { "id": "update", "name": "编辑", "enabled": false, "granted": true },
              { "id": "add", "name": "新增", "enabled": false, "granted": true }
            ],
            "createTime": 1684981409173,
            "granted": true
          },
          {
            "id": "9d1e96f17649ef5e7b8e7c6bb8e7b775",
            "parentId": "fd1670b860ae58cc58bcd01d027ccd35",
            "path": "qpew-EZKY",
            "sortIndex": 3,
            "level": 2,
            "owner": "iot",
            "name": "角色管理",
            "code": "system/Role",
            "icon": "icon-jiaoseguanli",
            "url": "/system/Role",
            "buttons": [
              { "id": "delete", "name": "删除", "enabled": false, "granted": true },
              { "id": "update", "name": "编辑", "enabled": false, "granted": true },
              { "id": "add", "name": "新增", "enabled": false, "granted": true },
              { "id": "view", "name": "查看", "enabled": false, "granted": true }
            ],
            "createTime": 1684981409173,
            "granted": true
          },
          {
            "id": "dcb6fa15da2eae8a4fdb71755edbc2bb",
            "parentId": "fd1670b860ae58cc58bcd01d027ccd35",
            "path": "qpew-U6Go",
            "sortIndex": 4,
            "level": 2,
            "owner": "iot",
            "name": "菜单管理",
            "code": "system/Menu",
            "icon": "icon-caidanguanli",
            "url": "/system/Menu",
            "buttons": [
              { "id": "view", "name": "查看", "enabled": false, "granted": true },
              { "id": "update", "name": "编辑", "enabled": false, "granted": true },
              { "id": "delete", "name": "删除", "enabled": false, "granted": true },
              { "id": "add", "name": "新增", "enabled": false, "granted": true }
            ],
            "createTime": 1684981409173,
            "granted": true
          },
          {
            "id": "da14fad88888dc13024e8261ff8fc2b5",
            "parentId": "fd1670b860ae58cc58bcd01d027ccd35",
            "path": "qpew-JrpJ",
            "sortIndex": 5,
            "level": 2,
            "owner": "iot",
            "name": "权限管理",
            "code": "system/Permission",
            "icon": "icon-quanxianguanli",
            "url": "/system/Permission",
            "buttons": [
              { "id": "view", "name": "查看", "enabled": false, "granted": true },
              { "id": "action", "name": "启/禁用", "enabled": false, "granted": true },
              { "id": "export", "name": "导出", "enabled": false, "granted": true },
              { "id": "import", "name": "导入", "enabled": false, "granted": true },
              { "id": "delete", "name": "删除", "enabled": false, "granted": true },
              { "id": "update", "name": "编辑", "enabled": false, "granted": true },
              { "id": "add", "name": "新增", "enabled": false, "granted": true }
            ],
            "createTime": 1684981409173,
            "granted": true
          },
          {
            "id": "2fa02b8758fe82a6b9666f4ebb1bbd03",
            "parentId": "fd1670b860ae58cc58bcd01d027ccd35",
            "path": "qpew-PbZE",
            "sortIndex": 6,
            "level": 2,
            "owner": "iot",
            "name": "关系配置",
            "code": "system/Relationship",
            "icon": "icon-shuxingpeizhi",
            "url": "/system/Relationship",
            "buttons": [
              { "id": "update", "name": "编辑", "enabled": false, "granted": true },
              { "id": "delete", "name": "删除", "enabled": false, "granted": true },
              { "id": "view", "name": "查看", "enabled": false, "granted": true },
              { "id": "add", "name": "新增", "enabled": false, "granted": true }
            ],
            "createTime": 1684981409173,
            "granted": true
          }
        ],
        "createTime": 1685805899336,
        "granted": true
      }
    ],
    "status": 200,
    "timestamp": 1687480452252
  });

// /user/settings/view/user
Mock.mock(/\/user\/settings\/view\/user/, {
  "message": "success",
  "result": {
      "id": "05f9f39656acca18fe3b82dafd9eba62",
      "userId": "1199596756811550720",
      "type": "view",
      "key": "user",
      "name": "view",
      "content": "comprehensive",
      "createTime": 1672813130110
  },
  "status": 200,
  "timestamp": 1687271505732
});

// /device-instance/_query
Mock.mock(/\/device-instance\/_query/, {
  "message": "success",
  "result": {
      "pageIndex": 0,
      "pageSize": 12,
      "total": 4,
      "data": [
          {
              "id": "mBHQ5xJ1tWi2pYjt83G4",
              "photoUrl": "http://2e026133o7.51mypc.cn:39805/upload/20230610/1667377458216259584.png",
              "name": "A型-电池监控设备实例-0",
              "describe": "ddddd",
              "productId": "direct",
              "productName": "电池组-监控设备-A型",
              "state": {
                  "text": "禁用",
                  "value": "notActive"
              },
              "creatorId": "1199596756811550720",
              "creatorName": "超级管理员",
              "createTime": 1686368308815,
              "features": [],
              "modifyTime": 1686404458855,
              "modifierId": "1199596756811550720",
              "modifierName": "超级管理员"
          },
          {
              "id": "1665600503213522944",
              "photoUrl": "http://10.1.1.109:5173/images/device/instance/device-card.png",
              "name": "温度采集A点",
              "describe": "AAA",
              "productId": "T0001",
              "productName": "库房温度传感设备",
              "configuration": {
                  "creatorId": "1199596756811550720",
                  "deviceName": "温度采集A点",
                  "productName": "库房温度传感设备"
              },
              "state": {
                  "text": "离线",
                  "value": "offline"
              },
              "creatorId": "1199596756811550720",
              "creatorName": "超级管理员",
              "createTime": 1685945079899,
              "registryTime": 1685960245935,
              "features": [],
              "modifyTime": 1685945079899,
              "modifierId": "1199596756811550720",
              "modifierName": "超级管理员"
          },
          {
              "id": "13910002000",
              "photoUrl": "/images/device-type-3-big.png",
              "name": "TCP-温度传感",
              "productId": "1000",
              "productName": "TCP协议-温度传感器设备",
              "state": {
                  "text": "禁用",
                  "value": "notActive"
              },
              "creatorId": "1199596756811550720",
              "creatorName": "超级管理员",
              "createTime": 1680617812350,
              "registryTime": 1680617835502,
              "features": [],
              "modifyTime": 1686399836227,
              "modifierId": "1199596756811550720",
              "modifierName": "超级管理员"
          },
          {
              "id": "13980001000",
              "photoUrl": "http://2e026133o7.51mypc.cn:39805/upload/20230610/1667377458216259584.png",
              "name": "A型-电池监控设备实例-0",
              "productId": "direct",
              "productName": "电池组-监控设备-A型",
              "state": {
                  "text": "禁用",
                  "value": "notActive"
              },
              "creatorId": "1199596756811550720",
              "creatorName": "超级管理员",
              "createTime": 1680599392434,
              "registryTime": 1680599444265,
              "features": [],
              "modifyTime": 1686373185155,
              "modifierId": "1199596756811550720",
              "modifierName": "超级管理员"
          }
      ]
  },
  "status": 200,
  "timestamp": 1687271693635
});

// /aw/base/warehouse/_query/no-paging
Mock.mock(/\/aw\/base\/warehouse\/_query\/no-paging/, {
  "message": "success",
  "result": [
      {
          "id": "1666967935716671488",
          "creatorId": "1199596756811550720",
          "createTime": 1686271101268,
          "modifierId": "1199596756811550720",
          "modifyTime": 1686271101268,
          "name": "SSSSS",
          "code": "TESTff"
      },
      {
          "id": "1666967933493690368",
          "creatorId": "1199596756811550720",
          "createTime": 1686271100708,
          "modifierId": "1199596756811550720",
          "modifyTime": 1686271100709,
          "name": "SSSSS",
          "code": "TESTff"
      },
      {
          "id": "1666817028031967232",
          "creatorId": "1199596756811550720",
          "createTime": 1686235122028,
          "modifierId": "1199596756811550720",
          "modifyTime": 1686235122028,
          "institutionId": "1666816262852505600",
          "name": "档案二库"
      },
      {
          "id": "1666816958972751872",
          "creatorId": "1199596756811550720",
          "createTime": 1686235105562,
          "modifierId": "1199596756811550720",
          "modifyTime": 1686235105562,
          "institutionId": "1666816262852505600",
          "name": "档案一库"
      },
      {
          "id": "1666816822888558592",
          "creatorId": "1199596756811550720",
          "createTime": 1686235085893,
          "modifierId": "1199596756811550720",
          "modifyTime": 1686235085893,
          "institutionId": "1666816401021267968",
          "name": "新区档案库房"
      },
      {
          "id": "1666816822498488320",
          "creatorId": "1199596756811550720",
          "createTime": 1686235073044,
          "modifierId": "1199596756811550720",
          "modifyTime": 1686235073044,
          "institutionId": "1666816401021267968",
          "name": "中心档案库房"
      }
  ],
  "status": 200,
  "timestamp": 1687271743783
});

// /aw/base/intensive-frame/_query
Mock.mock(/\/aw\/base\/intensive-frame\/_query/, {
  "message": "success",
  "result": {
      "pageIndex": 0,
      "pageSize": 12,
      "total": 3,
      "data": [
          {
              "id": "1668056517938241536",
              "creatorId": "1199596756811550720",
              "createTime": 1686530639505,
              "modifierId": "1199596756811550720",
              "modifyTime": 1686530639505,
              "warehouseId": "1666816822498488320",
              "code": "A001",
              "name": "密集架a01",
              "storageType": "库",
              "linkAddress": "aaa",
              "brand": "aaa",
              "cols": "1",
              "layers": "2",
              "groups": "3",
              "manufactureDate": "2023-06-12"
          },
          {
              "id": "1667182191691153408",
              "memo": "string",
              "sn": 0,
              "flag": 0,
              "creatorId": "1199596756811550720",
              "creatorOrgId": "string",
              "createTime": 1686493047477,
              "modifierId": "1199596756811550720",
              "modifyTime": 1686493047477,
              "version": 0,
              "warehouseId": "1666817028031967232",
              "code": "CODE_001",
              "name": "档案柜1",
              "storageType": "库",
              "linkAddress": "111",
              "brand": "123",
              "cols": "1",
              "layers": "1",
              "groups": "1",
              "custodian": "123",
              "phone": "123",
              "img": "[{\"uid\":\"vc-upload-1686492353834-5\",\"name\":\"icon.png\",\"status\":\"done\",\"url\":\"http://2e026133o7.51mypc.cn:39805/upload/20230611/1667898837199212544.png\"}]",
              "manufactureDate": "2023-06-10"
          },
          {
              "id": "1667181507818274816",
              "memo": "string",
              "sn": 0,
              "flag": 0,
              "creatorId": "1199596756811550720",
              "creatorOrgId": "string",
              "createTime": 1686322020780,
              "modifierId": "1199596756811550720",
              "modifyTime": 1686322020780,
              "version": 0,
              "warehouseId": "string",
              "code": "string",
              "name": "string",
              "storageType": "string",
              "linkAddress": "string",
              "brand": "string",
              "cols": "string",
              "layers": "string",
              "groups": "string",
              "custodian": "string",
              "phone": "string",
              "img": "string",
              "manufactureDate": "2023-06-09"
          }
      ]
  },
  "status": 200,
  "timestamp": 1687271743884
});