function _optionalChain(ops) { let lastAccessLHS = undefined; let value = ops[0]; let i = 1; while (i < ops.length) {
    const op = ops[i];
    const fn = ops[i + 1];
    i += 2;
    if ((op === 'optionalAccess' || op === 'optionalCall') && value == null) {
        return undefined;
    }
    if (op === 'access' || op === 'optionalAccess') {
        lastAccessLHS = value;
        value = fn(value);
    }
    else if (op === 'call' || op === 'optionalCall') {
        value = fn((...args) => value.call(lastAccessLHS, ...args));
        lastAccessLHS = undefined;
    }
} return value; }
/* Analyzed bindings: {
  "computed": "setup-const",
  "inject": "setup-const",
  "onBeforeUnmount": "setup-const",
  "ref": "setup-const",
  "toRef": "setup-const",
  "isClient": "setup-maybe-ref",
  "useEventListener": "setup-maybe-ref",
  "scrollbarContextKey": "setup-maybe-ref",
  "throwError": "setup-maybe-ref",
  "BAR_MAP": "setup-maybe-ref",
  "renderThumbStyle": "setup-maybe-ref",
  "useNamespace": "setup-maybe-ref",
  "thumbProps": "setup-maybe-ref",
  "COMPONENT_NAME": "setup-const",
  "props": "setup-reactive-const",
  "scrollbar": "setup-maybe-ref",
  "ns": "setup-maybe-ref",
  "instance": "setup-ref",
  "thumb": "setup-ref",
  "thumbState": "setup-ref",
  "visible": "setup-ref",
  "cursorDown": "setup-let",
  "cursorLeave": "setup-let",
  "originalOnSelectStart": "setup-let",
  "bar": "setup-maybe-ref",
  "thumbStyle": "setup-maybe-ref",
  "offsetRatio": "setup-maybe-ref",
  "clickThumbHandler": "setup-const",
  "clickTrackHandler": "setup-const",
  "startDrag": "setup-const",
  "mouseMoveDocumentHandler": "setup-const",
  "mouseUpDocumentHandler": "setup-const",
  "mouseMoveScrollbarHandler": "setup-const",
  "mouseLeaveScrollbarHandler": "setup-const",
  "restoreOnselectstart": "setup-const"
} */
import { defineComponent as _defineComponent } from 'vue';
import { unref as _unref, normalizeClass as _normalizeClass, normalizeStyle as _normalizeStyle, createElementVNode as _createElementVNode, vShow as _vShow, withDirectives as _withDirectives, Transition as _Transition, withCtx as _withCtx, openBlock as _openBlock, createBlock as _createBlock } from "vue";
import { computed, inject, onBeforeUnmount, ref, toRef } from 'vue';
import { isClient, useEventListener } from '@vueuse/core';
import { scrollbarContextKey } from './tokens';
import { throwError, BAR_MAP, renderThumbStyle } from '../util/scrollbar';
import { useNamespace } from './hooks';
import { thumbProps } from './thumbUtil';
const __sfc_main__ = /*#__PURE__*/ _defineComponent({
    props: thumbProps,
    setup(__props) {
        const props = __props;
        const COMPONENT_NAME = 'Thumb';
        const scrollbar = inject(scrollbarContextKey);
        const ns = useNamespace('scrollbar');
        if (!scrollbar)
            throwError(COMPONENT_NAME, 'can not inject scrollbar context');
        const instance = ref();
        const thumb = ref();
        const thumbState = ref({});
        const visible = ref(false);
        let cursorDown = false;
        let cursorLeave = false;
        let originalOnSelectStart = isClient ? document.onselectstart : null;
        const bar = computed(() => BAR_MAP[props.vertical ? 'vertical' : 'horizontal']);
        const thumbStyle = computed(() => renderThumbStyle({
            size: props.size,
            move: props.move,
            bar: bar.value,
        }));
        const offsetRatio = computed(() => 
        // offsetRatioX = original width of thumb / current width of thumb / ratioX
        // offsetRatioY = original height of thumb / current height of thumb / ratioY
        // instance height = wrap height - GAP
        instance.value[bar.value.offset] ** 2 /
            scrollbar.wrapElement[bar.value.scrollSize] /
            props.ratio /
            thumb.value[bar.value.offset]);
        const clickThumbHandler = (e) => {
            // prevent click event of middle and right button
            e.stopPropagation();
            if (e.ctrlKey || [1, 2].includes(e.button))
                return;
            _optionalChain([window, 'access', _2 => _2.getSelection, 'call', _3 => _3(), 'optionalAccess', _4 => _4.removeAllRanges, 'call', _5 => _5()]);
            startDrag(e);
            const el = e.currentTarget;
            if (!el)
                return;
            thumbState.value[bar.value.axis] =
                el[bar.value.offset] -
                    (e[bar.value.client] - el.getBoundingClientRect()[bar.value.direction]);
        };
        const clickTrackHandler = (e) => {
            if (!thumb.value || !instance.value || !scrollbar.wrapElement)
                return;
            const offset = Math.abs((e.target).getBoundingClientRect()[bar.value.direction] -
                e[bar.value.client]);
            const thumbHalf = thumb.value[bar.value.offset] / 2;
            const thumbPositionPercentage = ((offset - thumbHalf) * 100 * offsetRatio.value) /
                instance.value[bar.value.offset];
            scrollbar.wrapElement[bar.value.scroll] =
                (thumbPositionPercentage *
                    scrollbar.wrapElement[bar.value.scrollSize]) /
                    100;
        };
        const startDrag = (e) => {
            e.stopImmediatePropagation();
            cursorDown = true;
            document.addEventListener('mousemove', mouseMoveDocumentHandler);
            document.addEventListener('mouseup', mouseUpDocumentHandler);
            originalOnSelectStart = document.onselectstart;
            document.onselectstart = () => false;
        };
        const mouseMoveDocumentHandler = (e) => {
            if (!instance.value || !thumb.value)
                return;
            if (cursorDown === false)
                return;
            const prevPage = thumbState.value[bar.value.axis];
            if (!prevPage)
                return;
            const offset = (instance.value.getBoundingClientRect()[bar.value.direction] -
                e[bar.value.client]) *
                -1;
            const thumbClickPosition = thumb.value[bar.value.offset] - prevPage;
            const thumbPositionPercentage = ((offset - thumbClickPosition) * 100 * offsetRatio.value) /
                instance.value[bar.value.offset];
            scrollbar.wrapElement[bar.value.scroll] =
                (thumbPositionPercentage *
                    scrollbar.wrapElement[bar.value.scrollSize]) /
                    100;
        };
        const mouseUpDocumentHandler = () => {
            cursorDown = false;
            thumbState.value[bar.value.axis] = 0;
            document.removeEventListener('mousemove', mouseMoveDocumentHandler);
            document.removeEventListener('mouseup', mouseUpDocumentHandler);
            restoreOnselectstart();
            if (cursorLeave)
                visible.value = false;
        };
        const mouseMoveScrollbarHandler = () => {
            cursorLeave = false;
            visible.value = !!props.size;
        };
        const mouseLeaveScrollbarHandler = () => {
            cursorLeave = true;
            visible.value = cursorDown;
        };
        onBeforeUnmount(() => {
            restoreOnselectstart();
            document.removeEventListener('mouseup', mouseUpDocumentHandler);
        });
        const restoreOnselectstart = () => {
            if (document.onselectstart !== originalOnSelectStart)
                document.onselectstart = originalOnSelectStart;
        };
        useEventListener(toRef(scrollbar, 'scrollbarElement'), 'mousemove', mouseMoveScrollbarHandler);
        useEventListener(toRef(scrollbar, 'scrollbarElement'), 'mouseleave', mouseLeaveScrollbarHandler);
        return (_ctx, _cache) => {
            return (_openBlock(), _createBlock(_Transition, {
                name: _unref(ns).b('fade'),
                persisted: ""
            }, {
                default: _withCtx(() => [
                    _withDirectives(_createElementVNode("div", {
                        ref_key: "instance",
                        ref: instance,
                        class: _normalizeClass([_unref(ns).e('bar'), _unref(ns).is(_unref(bar).key)]),
                        onMousedown: clickTrackHandler
                    }, [
                        _createElementVNode("div", {
                            ref_key: "thumb",
                            ref: thumb,
                            class: _normalizeClass(_unref(ns).e('thumb')),
                            style: _normalizeStyle(_unref(thumbStyle)),
                            onMousedown: clickThumbHandler
                        }, null, 38 /* CLASS, STYLE, HYDRATE_EVENTS */)
                    ], 34 /* CLASS, HYDRATE_EVENTS */), [
                        [_vShow, _ctx.always || visible.value]
                    ])
                ]),
                _: 1 /* STABLE */
            }, 8 /* PROPS */, ["name"]));
        };
    }
});
export default __sfc_main__;