"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scrollbarProps = exports.scrollbarEmits = void 0;
var _scrollbar = require("../util/scrollbar");
var scrollbarProps = {
  /**
   * @description height of scrollbar
   */
  height: {
    type: [String, Number],
    default: ''
  },
  /**
   * @description max height of scrollbar
   */
  maxHeight: {
    type: [String, Number],
    default: ''
  },
  /**
   * @description whether to use the native scrollbar
   */
  native: {
    type: Boolean,
    default: false
  },
  /**
   * @description style of wrap
   */
  wrapStyle: {
    type: (0, _scrollbar.definePropType)([String, Object, Array]),
    default: ''
  },
  /**
   * @description class of wrap
   */
  wrapClass: {
    type: [String, Array],
    default: ''
  },
  /**
   * @description class of view
   */
  viewClass: {
    type: [String, Array],
    default: ''
  },
  /**
   * @description style of view
   */
  viewStyle: {
    type: [String, Array, Object],
    default: ''
  },
  /**
   * @description do not respond to container size changes, if the container size does not change, it is better to set it to optimize performance
   */
  noresize: Boolean,
  /**
   * @description element tag of the view
   */
  tag: {
    type: String,
    default: 'div'
  },
  /**
   * @description always show
   */
  always: Boolean,
  /**
   * @description minimum size of scrollbar
   */
  minSize: {
    type: Number,
    default: 20
  }
};
exports.scrollbarProps = scrollbarProps;
var scrollbarEmits = {
  scroll: function scroll(_ref) {
    var scrollTop = _ref.scrollTop,
      scrollLeft = _ref.scrollLeft;
    return [scrollTop, scrollLeft].every(_scrollbar.isNumber);
  }
};
exports.scrollbarEmits = scrollbarEmits;