function _optionalChain(ops) { let lastAccessLHS = undefined; let value = ops[0]; let i = 1; while (i < ops.length) {
    const op = ops[i];
    const fn = ops[i + 1];
    i += 2;
    if ((op === 'optionalAccess' || op === 'optionalCall') && value == null) {
        return undefined;
    }
    if (op === 'access' || op === 'optionalAccess') {
        lastAccessLHS = value;
        value = fn(value);
    }
    else if (op === 'call' || op === 'optionalCall') {
        value = fn((...args) => value.call(lastAccessLHS, ...args));
        lastAccessLHS = undefined;
    }
} return value; }
/* Analyzed bindings: {
  "computed": "setup-const",
  "nextTick": "setup-const",
  "onMounted": "setup-const",
  "onUpdated": "setup-const",
  "provide": "setup-const",
  "reactive": "setup-const",
  "ref": "setup-const",
  "watch": "setup-const",
  "useEventListener": "setup-maybe-ref",
  "useResizeObserver": "setup-maybe-ref",
  "addUnit": "setup-maybe-ref",
  "debugWarn": "setup-maybe-ref",
  "isNumber": "setup-maybe-ref",
  "isObject": "setup-maybe-ref",
  "GAP": "setup-maybe-ref",
  "scrollbarContextKey": "setup-maybe-ref",
  "useNamespace": "setup-maybe-ref",
  "Bar": "setup-const",
  "scrollbarEmits": "setup-maybe-ref",
  "scrollbarProps": "setup-maybe-ref",
  "omit": "setup-maybe-ref",
  "COMPONENT_NAME": "setup-const",
  "props": "setup-reactive-const",
  "baseProps": "setup-maybe-ref",
  "emit": "setup-const",
  "ns": "setup-maybe-ref",
  "stopResizeObserver": "setup-let",
  "stopResizeListener": "setup-let",
  "scrollbarRef": "setup-ref",
  "wrapRef": "setup-ref",
  "resizeRef": "setup-ref",
  "sizeWidth": "setup-ref",
  "sizeHeight": "setup-ref",
  "barRef": "setup-ref",
  "ratioY": "setup-ref",
  "ratioX": "setup-ref",
  "style": "setup-maybe-ref",
  "wrapKls": "setup-maybe-ref",
  "resizeKls": "setup-maybe-ref",
  "handleScroll": "setup-const",
  "scrollTo": "setup-const",
  "setScrollTop": "setup-const",
  "setScrollLeft": "setup-const",
  "update": "setup-const"
} */
import { defineComponent as _defineComponent } from 'vue';
import { unref as _unref, renderSlot as _renderSlot, resolveDynamicComponent as _resolveDynamicComponent, normalizeClass as _normalizeClass, normalizeStyle as _normalizeStyle, withCtx as _withCtx, openBlock as _openBlock, createBlock as _createBlock, createElementVNode as _createElementVNode, createCommentVNode as _createCommentVNode, createElementBlock as _createElementBlock } from "vue";
import { computed, nextTick, onMounted, onUpdated, provide, reactive, ref, watch, } from 'vue';
import { useEventListener, useResizeObserver } from '@vueuse/core';
import { addUnit, debugWarn, isNumber, isObject, GAP } from '../util/scrollbar';
import { scrollbarContextKey } from './tokens';
import { useNamespace } from './hooks';
import Bar from './bar.js';
import { scrollbarEmits, scrollbarProps } from './scrollbarUtil';
import { omit } from 'lodash';
const __sfc_main__ = /*#__PURE__*/ _defineComponent({
    props: scrollbarProps,
    emits: scrollbarEmits,
    setup(__props, { expose, emit }) {
        const props = __props;
        const COMPONENT_NAME = 'ElScrollbar';
        // defineOptions({
        //   name: COMPONENT_NAME,
        // })
        const baseProps = omit(props, ['height']);
        const ns = useNamespace('scrollbar');
        let stopResizeObserver = undefined;
        let stopResizeListener = undefined;
        const scrollbarRef = ref();
        const wrapRef = ref();
        const resizeRef = ref();
        const sizeWidth = ref('0');
        const sizeHeight = ref('0');
        const barRef = ref();
        const ratioY = ref(1);
        const ratioX = ref(1);
        const style = computed(() => {
            const style = {};
            if (props.height)
                style.height = addUnit(props.height);
            if (props.maxHeight)
                style.maxHeight = addUnit(props.maxHeight);
            return [props.wrapStyle, style];
        });
        const wrapKls = computed(() => {
            return [
                props.wrapClass,
                ns.e('wrap'),
                { [ns.em('wrap', 'hidden-default')]: !props.native },
            ];
        });
        const resizeKls = computed(() => {
            return [ns.e('view'), props.viewClass];
        });
        const handleScroll = () => {
            if (wrapRef.value) {
                _optionalChain([barRef, 'access', _2 => _2.value, 'optionalAccess', _3 => _3.handleScroll, 'call', _4 => _4(wrapRef.value)]);
                emit('scroll', {
                    scrollTop: wrapRef.value.scrollTop,
                    scrollLeft: wrapRef.value.scrollLeft,
                });
            }
        };
        // TODO: refactor method overrides, due to script setup dts
        // @ts-nocheck
        function scrollTo(arg1, arg2) {
            if (isObject(arg1)) {
                wrapRef.value.scrollTo(arg1);
            }
            else if (isNumber(arg1) && isNumber(arg2)) {
                wrapRef.value.scrollTo(arg1, arg2);
            }
        }
        const setScrollTop = (value) => {
            if (!isNumber(value)) {
                debugWarn(COMPONENT_NAME, 'value must be a number');
                return;
            }
            wrapRef.value.scrollTop = value;
        };
        const setScrollLeft = (value) => {
            if (!isNumber(value)) {
                debugWarn(COMPONENT_NAME, 'value must be a number');
                return;
            }
            wrapRef.value.scrollLeft = value;
        };
        const update = () => {
            if (!wrapRef.value)
                return;
            const offsetHeight = wrapRef.value.offsetHeight - GAP;
            const offsetWidth = wrapRef.value.offsetWidth - GAP;
            const originalHeight = offsetHeight ** 2 / wrapRef.value.scrollHeight;
            const originalWidth = offsetWidth ** 2 / wrapRef.value.scrollWidth;
            const height = Math.max(originalHeight, props.minSize);
            const width = Math.max(originalWidth, props.minSize);
            ratioY.value =
                originalHeight /
                    (offsetHeight - originalHeight) /
                    (height / (offsetHeight - height));
            ratioX.value =
                originalWidth /
                    (offsetWidth - originalWidth) /
                    (width / (offsetWidth - width));
            sizeHeight.value = height + GAP < offsetHeight ? `${height}px` : '';
            sizeWidth.value = width + GAP < offsetWidth ? `${width}px` : '';
        };
        watch(() => props.noresize, (noresize) => {
            if (noresize) {
                _optionalChain([stopResizeObserver, 'optionalCall', _5 => _5()]);
                _optionalChain([stopResizeListener, 'optionalCall', _6 => _6()]);
            }
            else {
                ({ stop: stopResizeObserver } = useResizeObserver(resizeRef, update));
                stopResizeListener = useEventListener('resize', update);
            }
        }, { immediate: true });
        watch(() => [props.maxHeight, props.height], () => {
            if (!props.native)
                nextTick(() => {
                    update();
                    if (wrapRef.value) {
                        _optionalChain([barRef, 'access', _7 => _7.value, 'optionalAccess', _8 => _8.handleScroll, 'call', _9 => _9(wrapRef.value)]);
                    }
                });
        });
        provide(scrollbarContextKey, reactive({
            scrollbarElement: scrollbarRef,
            wrapElement: wrapRef,
        }));
        onMounted(() => {
            if (!props.native)
                nextTick(() => {
                    update();
                });
        });
        onUpdated(() => update());
        expose({
            /** @description scrollbar wrap ref */
            wrapRef,
            /** @description update scrollbar state manually */
            update,
            /** @description scrolls to a particular set of coordinates */
            scrollTo,
            /** @description set distance to scroll top */
            setScrollTop,
            /** @description set distance to scroll left */
            setScrollLeft,
            /** @description handle scroll event */
            handleScroll,
        });
        return (_ctx, _cache) => {
            return (_openBlock(), _createElementBlock("div", {
                ref_key: "scrollbarRef",
                ref: scrollbarRef,
                class: _normalizeClass(_unref(ns).b())
            }, [
                _createElementVNode("div", {
                    ref_key: "wrapRef",
                    ref: wrapRef,
                    class: _normalizeClass(_unref(wrapKls)),
                    style: _normalizeStyle(_unref(style)),
                    onScroll: handleScroll
                }, [
                    (_openBlock(), _createBlock(_resolveDynamicComponent(_ctx.tag), {
                        ref_key: "resizeRef",
                        ref: resizeRef,
                        class: _normalizeClass(_unref(resizeKls)),
                        style: _normalizeStyle(_ctx.viewStyle)
                    }, {
                        default: _withCtx(() => [
                            _renderSlot(_ctx.$slots, "default")
                        ]),
                        _: 3 /* FORWARDED */
                    }, 8 /* PROPS */, ["class", "style"]))
                ], 38 /* CLASS, STYLE, HYDRATE_EVENTS */),
                (!_ctx.native)
                    ? (_openBlock(), _createBlock(Bar, {
                        key: 0,
                        ref_key: "barRef",
                        ref: barRef,
                        height: sizeHeight.value,
                        width: sizeWidth.value,
                        always: _ctx.always,
                        "ratio-x": ratioX.value,
                        "ratio-y": ratioY.value
                    }, null, 8 /* PROPS */, ["height", "width", "always", "ratio-x", "ratio-y"]))
                    : _createCommentVNode("v-if", true)
            ], 2 /* CLASS */));
        };
    }
});
export default __sfc_main__;