"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.provideGlobalConfig = exports.defaultNamespace = void 0;
exports.useGlobalConfig = useGlobalConfig;
exports.useNamespace = void 0;
var _createForOfIteratorHelper2 = _interopRequireDefault(require("@babel/runtime/helpers/createForOfIteratorHelper"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _vue = require("vue");
var _tokens = require("./tokens");
var _scrollbar = require("../util/scrollbar");
//use-global-config
var globalConfig = (0, _vue.ref)();
function useGlobalConfig(key) {
  var defaultValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;
  var config = (0, _vue.getCurrentInstance)() ? (0, _vue.inject)(_tokens.configProviderContextKey, globalConfig) : globalConfig;
  if (key) {
    return (0, _vue.computed)(function () {
      var _config$value$key, _config$value;
      return (_config$value$key = (_config$value = config.value) === null || _config$value === void 0 ? void 0 : _config$value[key]) !== null && _config$value$key !== void 0 ? _config$value$key : defaultValue;
    });
  } else {
    return config;
  }
}
var provideGlobalConfig = function provideGlobalConfig(config, app) {
  var _app$provide;
  var global = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var inSetup = !!(0, _vue.getCurrentInstance)();
  var oldConfig = inSetup ? useGlobalConfig() : undefined;
  var provideFn = (_app$provide = app === null || app === void 0 ? void 0 : app.provide) !== null && _app$provide !== void 0 ? _app$provide : inSetup ? _vue.provide : undefined;
  if (!provideFn) {
    (0, _scrollbar.debugWarn)('provideGlobalConfig', 'provideGlobalConfig() can only be used inside setup().');
    return;
  }
  var context = (0, _vue.computed)(function () {
    var cfg = (0, _vue.unref)(config);
    if (!(oldConfig !== null && oldConfig !== void 0 && oldConfig.value)) return cfg;
    return mergeConfig(oldConfig.value, cfg);
  });
  provideFn(_tokens.configProviderContextKey, context);
  if (global || !globalConfig.value) {
    globalConfig.value = context.value;
  }
  return context;
};
exports.provideGlobalConfig = provideGlobalConfig;
var mergeConfig = function mergeConfig(a, b) {
  var keys = (0, _toConsumableArray2.default)(new Set([].concat((0, _toConsumableArray2.default)((0, _scrollbar.keysOf)(a)), (0, _toConsumableArray2.default)((0, _scrollbar.keysOf)(b)))));
  var obj = {};
  var _iterator = (0, _createForOfIteratorHelper2.default)(keys),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var _b$key;
      var key = _step.value;
      obj[key] = (_b$key = b[key]) !== null && _b$key !== void 0 ? _b$key : a[key];
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  return obj;
};
//use-namespace
var defaultNamespace = 'el';
exports.defaultNamespace = defaultNamespace;
var statePrefix = 'is-';
var _bem = function _bem(namespace, block, blockSuffix, element, modifier) {
  var cls = "".concat(namespace, "-").concat(block);
  if (blockSuffix) {
    cls += "-".concat(blockSuffix);
  }
  if (element) {
    cls += "__".concat(element);
  }
  if (modifier) {
    cls += "--".concat(modifier);
  }
  return cls;
};
var useNamespace = function useNamespace(block) {
  var namespace = useGlobalConfig('namespace', defaultNamespace);
  var b = function b() {
    var blockSuffix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
    return _bem(namespace.value, block, blockSuffix, '', '');
  };
  var e = function e(element) {
    return element ? _bem(namespace.value, block, '', element, '') : '';
  };
  var m = function m(modifier) {
    return modifier ? _bem(namespace.value, block, '', '', modifier) : '';
  };
  var be = function be(blockSuffix, element) {
    return blockSuffix && element ? _bem(namespace.value, block, blockSuffix, element, '') : '';
  };
  var em = function em(element, modifier) {
    return element && modifier ? _bem(namespace.value, block, '', element, modifier) : '';
  };
  var bm = function bm(blockSuffix, modifier) {
    return blockSuffix && modifier ? _bem(namespace.value, block, blockSuffix, '', modifier) : '';
  };
  var bem = function bem(blockSuffix, element, modifier) {
    return blockSuffix && element && modifier ? _bem(namespace.value, block, blockSuffix, element, modifier) : '';
  };
  var is = function is(name) {
    var state = (arguments.length <= 1 ? 0 : arguments.length - 1) >= 1 ? arguments.length <= 1 ? undefined : arguments[1] : true;
    return name && state ? "".concat(statePrefix).concat(name) : '';
  };
  // for css var
  // --el-xxx: value;
  var cssVar = function cssVar(object) {
    var styles = {};
    for (var key in object) {
      if (object[key]) {
        styles["--".concat(namespace.value, "-").concat(key)] = object[key];
      }
    }
    return styles;
  };
  // with block
  var cssVarBlock = function cssVarBlock(object) {
    var styles = {};
    for (var key in object) {
      if (object[key]) {
        styles["--".concat(namespace.value, "-").concat(block, "-").concat(key)] = object[key];
      }
    }
    return styles;
  };
  var cssVarName = function cssVarName(name) {
    return "--".concat(namespace.value, "-").concat(name);
  };
  var cssVarBlockName = function cssVarBlockName(name) {
    return "--".concat(namespace.value, "-").concat(block, "-").concat(name);
  };
  return {
    namespace: namespace,
    b: b,
    e: e,
    m: m,
    be: be,
    em: em,
    bm: bm,
    bem: bem,
    is: is,
    // css
    cssVar: cssVar,
    cssVarName: cssVarName,
    cssVarBlock: cssVarBlock,
    cssVarBlockName: cssVarBlockName
  };
};
exports.useNamespace = useNamespace;