/* Analyzed bindings: {
  "ref": "setup-const",
  "GAP": "setup-maybe-ref",
  "Thumb": "setup-const",
  "barProps": "setup-maybe-ref",
  "props": "setup-reactive-const",
  "moveX": "setup-ref",
  "moveY": "setup-ref",
  "handleScroll": "setup-const"
} */
import { defineComponent as _defineComponent } from 'vue';
import { createVNode as _createVNode, Fragment as _Fragment, openBlock as _openBlock, createElementBlock as _createElementBlock } from "vue";
import { ref } from 'vue';
import { GAP } from '../util/scrollbar';
import Thumb from './thumb.js';
import { barProps } from './barUtil';
const __sfc_main__ = /*#__PURE__*/ _defineComponent({
    props: barProps,
    setup(__props, { expose }) {
        const props = __props;
        const moveX = ref(0);
        const moveY = ref(0);
        const handleScroll = (wrap) => {
            if (wrap) {
                const offsetHeight = wrap.offsetHeight - GAP;
                const offsetWidth = wrap.offsetWidth - GAP;
                moveY.value = ((wrap.scrollTop * 100) / offsetHeight) * props.ratioY;
                moveX.value = ((wrap.scrollLeft * 100) / offsetWidth) * props.ratioX;
            }
        };
        expose({
            handleScroll,
        });
        return (_ctx, _cache) => {
            return (_openBlock(), _createElementBlock(_Fragment, null, [
                _createVNode(Thumb, {
                    move: moveX.value,
                    ratio: _ctx.ratioX,
                    size: _ctx.width,
                    always: _ctx.always
                }, null, 8 /* PROPS */, ["move", "ratio", "size", "always"]),
                _createVNode(Thumb, {
                    move: moveY.value,
                    ratio: _ctx.ratioY,
                    size: _ctx.height,
                    vertical: "",
                    always: _ctx.always
                }, null, 8 /* PROPS */, ["move", "ratio", "size", "always"])
            ], 64 /* STABLE_FRAGMENT */));
        };
    }
});
export default __sfc_main__;