import { AntdMatchComponents, kebabCase } from './antdv';
var matchComponents = [{
  pattern: /^Avatar/,
  styleDir: 'Avatar'
}, {
  pattern: /^AutoComplete/,
  styleDir: 'AutoComplete'
}, {
  pattern: /^Anchor/,
  styleDir: 'Anchor'
}, {
  pattern: /^Badge/,
  styleDir: 'Badge'
}, {
  pattern: /^Breadcrumb/,
  styleDir: 'Breadcrumb'
}, {
  pattern: /^Button/,
  styleDir: 'Button'
}, {
  pattern: /^Checkbox/,
  styleDir: 'Checkbox'
}, {
  pattern: /^CardSelect/,
  styleDir: 'CardSelect'
}, {
  pattern: /^Card/,
  styleDir: 'Card'
}, {
  pattern: /^Collapse/,
  styleDir: 'Collapse'
}, {
  pattern: /^Descriptions/,
  styleDir: 'Descriptions'
}, {
  pattern: /^RangePicker|^WeekPicker|^MonthPicker/,
  styleDir: 'DatePicker'
}, {
  pattern: /^Dropdown/,
  styleDir: 'Dropdown'
}, {
  pattern: /^Form/,
  styleDir: 'Form'
}, {
  pattern: /^InputNumber/,
  styleDir: 'InputNumber'
}, {
  pattern: /^Input|^Textarea/,
  styleDir: 'Input'
}, {
  pattern: /^Statistic/,
  styleDir: 'Statistic'
}, {
  pattern: /^CheckableTag/,
  styleDir: 'Tag'
}, {
  pattern: /^TimeRangePicker/,
  styleDir: 'TimePicker'
}, {
  pattern: /^Layout/,
  styleDir: 'Layout'
}, {
  pattern: /^Menu|^SubMenu/,
  styleDir: 'Menu'
}, {
  pattern: /^Table/,
  styleDir: 'Table'
}, {
  pattern: /^TimePicker|^TimeRangePicker/,
  styleDir: 'TimePicker'
}, {
  pattern: /^Radio/,
  styleDir: 'Radio'
}, {
  pattern: /^Image/,
  styleDir: 'Image'
}, {
  pattern: /^List/,
  styleDir: 'List'
}, {
  pattern: /^Tab/,
  styleDir: 'Tabs'
}, {
  pattern: /^Mentions/,
  styleDir: 'Mentions'
}, {
  pattern: /^Step/,
  styleDir: 'Steps'
}, {
  pattern: /^Skeleton/,
  styleDir: 'Skeleton'
}, {
  pattern: /^Select/,
  styleDir: 'Select'
}, {
  pattern: /^TreeSelect/,
  styleDir: 'TreeSelect'
}, {
  pattern: /^Tree|^DirectoryTree/,
  styleDir: 'Tree'
}, {
  pattern: /^Typography/,
  styleDir: 'Typography'
}, {
  pattern: /^Timeline/,
  styleDir: 'Timeline'
}, {
  pattern: /^Upload/,
  styleDir: 'Upload'
}, {
  pattern: /^ProTable/,
  styleDir: 'ProTable'
}, {
  pattern: /^Search|^AdvancedSearch/,
  styleDir: 'Search'
}, {
  pattern: /^Ellipsis/,
  styleDir: 'Ellipsis'
}, {
  pattern: /^MonacoEditor/,
  styleDir: 'MonacoEditor'
}, {
  pattern: /^ProLayout/,
  styleDir: 'ProLayout'
}, {
  pattern: /^ScrollTable/,
  styleDir: 'ScrollTable'
}, {
  pattern: /^TableCard/,
  styleDir: 'TableCard'
}, {
  pattern: /^Scrollbar/,
  styleDir: 'Scrollbar'
}, {
  pattern: /^AIcon/,
  styleDir: 'AIcon'
}, {
  pattern: /^Tooltip/,
  styleDir: 'Tooltip'
}, {
  pattern: /^Empty/,
  styleDir: 'Empty'
}, {
  pattern: /^Popconfirm/,
  styleDir: 'Popconfirm'
}, {
  pattern: /^message/,
  styleDir: 'Message'
}, {
  pattern: /^Notification/,
  styleDir: 'Notification'
}];
function getStyleDir(compName) {
  var _isAntd = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var styleDir;
  var components = _isAntd ? AntdMatchComponents : matchComponents;
  var total = components.length;
  for (var i = 0; i < total; i++) {
    var matcher = components[i];
    if (compName.match(matcher.pattern)) {
      styleDir = matcher.styleDir;
      break;
    }
  }
  if (!styleDir) styleDir = _isAntd ? kebabCase(compName) : compName;
  return styleDir;
}
function getSideEffects(compName, options) {
  var _isAntd = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var _options$importStyle = options.importStyle,
    importStyle = _options$importStyle === void 0 ? true : _options$importStyle,
    _options$importLess = options.importLess,
    importLess = _options$importLess === void 0 ? false : _options$importLess;
  if (!importStyle) return;
  var lib = options.cjs ? 'lib' : 'es';
  var packageName = (options === null || options === void 0 ? void 0 : options.packageName) || 'jetlinks-ui-components';
  if (importStyle === 'less' || importLess) {
    var styleDir = getStyleDir(compName, _isAntd);
    return "".concat(packageName, "/").concat(lib, "/").concat(styleDir, "/style");
  } else {
    var _styleDir = getStyleDir(compName, _isAntd);
    return "".concat(packageName, "/").concat(lib, "/").concat(_styleDir, "/style/css");
  }
}
var filterName = ['message', 'Notification', 'AIcon'];
var primitiveNames = ['Affix', 'Anchor', 'AnchorLink', 'message', 'Notification', 'AutoComplete', 'AutoCompleteOptGroup', 'AutoCompleteOption', 'Alert', 'Avatar', 'AvatarGroup', 'BackTop', 'Badge', 'BadgeRibbon', 'Breadcrumb', 'BreadcrumbItem', 'BreadcrumbSeparator', 'Button', 'ButtonGroup', 'Calendar', 'Card', 'CardGrid', 'CardMeta', 'Collapse', 'CollapsePanel', 'Carousel', 'Cascader', 'Checkbox', 'CheckboxGroup', 'Col', 'Comment', 'ConfigProvider', 'DatePicker', 'MonthPicker', 'WeekPicker', 'RangePicker', 'QuarterPicker', 'Descriptions', 'DescriptionsItem', 'Divider', 'Dropdown', 'DropdownButton', 'Drawer', 'Empty', 'Form', 'FormItem', 'FormItemRest', 'Grid', 'Input', 'InputGroup', 'InputPassword', 'InputSearch', 'Textarea', 'Image', 'ImagePreviewGroup', 'InputNumber', 'Layout', 'LayoutHeader', 'LayoutSider', 'LayoutFooter', 'LayoutContent', 'List', 'ListItem', 'ListItemMeta', 'Menu', 'MenuDivider', 'MenuItem', 'MenuItemGroup', 'SubMenu', 'Mentions', 'MentionsOption', 'Modal', 'Statistic', 'StatisticCountdown', 'PageHeader', 'Pagination', 'Popconfirm', 'Popover', 'Progress', 'Radio', 'RadioButton', 'RadioGroup', 'Rate', 'Result', 'Row', 'Select', 'SelectOptGroup', 'SelectOption', 'Skeleton', 'SkeletonButton', 'SkeletonAvatar', 'SkeletonInput', 'SkeletonImage', 'Slider', 'Space', 'Spin', 'Steps', 'Step', 'Switch', 'Table', 'TableColumn', 'TableColumnGroup', 'TableSummary', 'TableSummaryRow', 'TableSummaryCell', 'Transfer', 'Tree', 'TreeNode', 'DirectoryTree', 'TreeSelect', 'TreeSelectNode', 'Tabs', 'TabPane', 'Tag', 'CheckableTag', 'TimePicker', 'TimeRangePicker', 'Timeline', 'TimelineItem', 'Tooltip', 'Typography', 'TypographyLink', 'TypographyParagraph', 'TypographyText', 'TypographyTitle', 'Upload', 'UploadDragger', 'LocaleProvider', 'ProTable', 'Search', 'AdvancedSearch', 'Ellipsis', 'MonacoEditor', 'ProLayout', 'ScrollTable', 'TableCard', 'Scrollbar', 'CardSelect', 'ColorPicker'];
var prefix = 'J';
var jetlinksNames;
function genJetlinksNames(primitiveNames) {
  jetlinksNames = new Set(primitiveNames.map(function (name) {
    return filterName.includes(name) ? name : "".concat(prefix).concat(name);
  }));
}
var antdvNames;
function genAntdNames(primitiveNames) {
  antdvNames = new Set(primitiveNames.map(function (name) {
    return "A".concat(name);
  }));
}
genAntdNames(primitiveNames.filter(function (key) {
  return !filterName.includes(key);
}));
genJetlinksNames(primitiveNames);
function isJetlinks(compName) {
  return jetlinksNames.has(compName);
}
function isAntdv(compName) {
  return antdvNames.has(compName);
}
function JetlinksVueResolver() {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  return {
    type: 'component',
    resolve: function resolve(name) {
      var _options$exclude;
      if (options.resolveIcons && name.match(/(Outlined|Filled|TwoTone)$/)) {
        return {
          name: name,
          from: '@ant-design/icons-vue'
        };
      }
      var _isJetlinks = isJetlinks(name);
      var _isAntd = isAntdv(name);
      if ((_isJetlinks || _isAntd) && !(options !== null && options !== void 0 && (_options$exclude = options.exclude) !== null && _options$exclude !== void 0 && _options$exclude.includes(name))) {
        var importName = filterName.includes(name) ? name : name.slice(1);
        options.packageName = _isJetlinks ? 'jetlinks-ui-components' : 'ant-design-vue';
        var path = "".concat(options.packageName, "/").concat(options.cjs ? 'lib' : 'es');
        var stylePath = getSideEffects(importName, options, _isAntd);
        if (_isJetlinks) {
          console.log(name, importName, stylePath);
        }
        return {
          name: importName,
          from: path,
          sideEffects: stylePath
        };
      }
    }
  };
}
export default JetlinksVueResolver;