import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { cloneDeep, isFunction, isString } from 'lodash-es';
/**
 * 处理like，nlike特殊值
 * @param v
 */
export var handleLikeValue = function handleLikeValue(v) {
  if (isString(v)) {
    return v.split('').reduce(function (pre, next) {
      var _next = next;
      if (next === '\\') {
        _next = '\\\\';
      } else if (next === '%') {
        _next = '\\%';
      }
      return pre + _next;
    }, '');
  }
  return v;
};
var handleItemValue = function handleItemValue(item, columnOptionMap) {
  var _item = columnOptionMap.get(item.column);
  if (!_item) return item;
  if (_item.rename) {
    item.column = _item.rename;
  }
  if (_item.handleValue && isFunction(_item.handleValue)) {
    item.value = _item.handleValue(item.value);
  }
  if (['like', 'nlike'].includes(item.termType) && !!item.value) {
    item.value = "%".concat(handleLikeValue(item.value), "%");
  }
  return item;
};
/**
 * 处理为外部使用
 * @terms {Array} 表单数据
 * @columnOptionMap {Map} column的Map对象
 */
export var termsParamsFormat = function termsParamsFormat(terms, columnOptionMap) {
  var type = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'adv';
  var searchType = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'terms';
  // 过滤掉terms中value无效的item
  var cloneParams = cloneDeep(terms);
  if (searchType == 'terms') {
    if (type === 'adv') {
      return {
        terms: cloneParams.terms.map(function (item) {
          if (item.terms) {
            item.terms = item.terms.filter(function (iItem) {
              return iItem && iItem.value !== undefined && iItem.value !== '' && iItem.column !== undefined;
            }).map(function (iItem) {
              return handleItemValue(iItem, columnOptionMap);
            });
          }
          return item;
        }).filter(function (item) {
          return item.terms.length;
        })
      };
    } else {
      console.log('cloneParams', cloneParams);
      return cloneParams.filter(function (iItem) {
        return iItem && iItem.value !== undefined && iItem.value !== '' && iItem.column !== undefined;
      }).map(function (iItem) {
        return handleItemValue(iItem, columnOptionMap);
      });
    }
  } else if (searchType == 'object') {
    var result = {};
    cloneParams.filter(function (item) {
      return item && item.value !== undefined && item.value !== '';
    }).forEach(function (item) {
      _extends(result, _defineProperty({}, item.column, item.value));
    });
    return result;
  }
};
/**
 * TreeSelect过滤
 * @param value 过滤值
 * @param treeNode
 * @param key
 */
export var filterTreeSelectNode = function filterTreeSelectNode(value, treeNode) {
  var _treeNode$key;
  var key = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'name';
  return (_treeNode$key = treeNode[key]) === null || _treeNode$key === void 0 ? void 0 : _treeNode$key.includes(value);
};
/**
 * Select过滤
 * @param value 过滤值
 * @param option
 * @param key
 */
export var filterSelectNode = function filterSelectNode(value, option) {
  var _option$key;
  var key = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'label';
  return (_option$key = option[key]) === null || _option$key === void 0 ? void 0 : _option$key.includes(value);
};
export var handleQData = function handleQData(terms) {
  // 排序, null 往后放
  terms.terms.forEach(function (a) {
    for (var i = 0; i < a.terms.length; i++) {
      for (var j = 0; j < a.terms.length - i - 1; j++) {
        if (!a.terms[j] && a.terms[j + 1]) {
          var temp = a.terms[j];
          a.terms[j] = a.terms[j + 1];
          a.terms[j + 1] = temp;
        }
      }
    }
  });
  return terms;
};
export var hasExpand = function hasExpand(terms) {
  var itemCount = 0;
  terms.forEach(function (a) {
    a.terms.forEach(function (b) {
      if (b) {
        itemCount += 1;
      }
    });
  });
  return itemCount >= 2;
};
export var compatibleOldTerms = function compatibleOldTerms() {
  var q = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '{"terms":[{"terms":[{"column":"name","termType":"like","value":"111","type":"and"}]}]}';
  var _terms = [{
    terms: [null, null, null]
  }, {
    terms: [null, null, null],
    type: 'and'
  }];
  try {
    var _terms$terms;
    var terms = JSON.parse(q || '{}');
    (_terms$terms = terms.terms) === null || _terms$terms === void 0 ? void 0 : _terms$terms.forEach(function (a, aIndex) {
      var _a$terms;
      a === null || a === void 0 ? void 0 : (_a$terms = a.terms) === null || _a$terms === void 0 ? void 0 : _a$terms.forEach(function (b, bIndex) {
        _terms[aIndex].terms[bIndex] = b;
      });
      if (a.type) {
        _terms[aIndex].type = a.type;
      }
    });
    return {
      terms: _terms
    };
  } catch (e) {
    return {
      terms: _terms
    };
  }
};
export var handleParamsToString = function handleParamsToString() {
  var terms = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'and';
  var _terms = [{
    terms: [null, null, null]
  }, {
    terms: [null, null, null],
    type: type
  }];
  var termsIndex = 0;
  var termsStar = 0;
  terms.forEach(function (item, index) {
    if (index > 2) {
      termsIndex = 1;
      termsStar = 4;
    }
    _terms[termsIndex].terms[index - termsStar] = item;
  });
  return JSON.stringify({
    terms: _terms
  });
};