/* Analyzed bindings: {
  "columns": "props",
  "type": "props",
  "column": "props",
  "style": "props",
  "class": "props",
  "labelWidth": "props",
  "JColumnsProps": "setup-maybe-ref",
  "SearchItemData": "setup-maybe-ref",
  "SearchProps": "setup-maybe-ref",
  "Terms": "setup-maybe-ref",
  "JButton": "setup-maybe-ref",
  "JRow": "setup-maybe-ref",
  "JCol": "setup-maybe-ref",
  "Form": "setup-maybe-ref",
  "FormItemRest": "setup-maybe-ref",
  "set": "setup-maybe-ref",
  "reactive": "setup-const",
  "ref": "setup-const",
  "termsParamsFormat": "setup-maybe-ref",
  "SearchItem": "setup-const",
  "props": "setup-reactive-const",
  "columnOptionMap": "setup-maybe-ref",
  "emit": "setup-const",
  "terms": "setup-reactive-const",
  "searchItems": "setup-ref",
  "itemValueChange": "setup-const",
  "handleItems": "setup-const",
  "searchSubmit": "setup-const",
  "resetNumber": "setup-ref",
  "reset": "setup-const"
} */
import { defineComponent as _defineComponent } from 'vue';
import { renderList as _renderList, Fragment as _Fragment, openBlock as _openBlock, createElementBlock as _createElementBlock, createVNode as _createVNode, unref as _unref, withCtx as _withCtx, createBlock as _createBlock, createTextVNode as _createTextVNode, normalizeStyle as _normalizeStyle, createElementVNode as _createElementVNode, normalizeClass as _normalizeClass } from "vue";
const _hoisted_1 = { class: "JSearch-content simple" };
const _hoisted_2 = { class: "JSearch-items" };
import { Button as JButton, Row as JRow, Col as JCol, Form, FormItemRest, } from '../components';
import { set } from 'lodash-es';
import { reactive, ref } from 'vue';
import { termsParamsFormat } from './util';
import SearchItem from './Item.js';
const __sfc_main__ = /*#__PURE__*/ _defineComponent({
    props: {
        columns: {
            type: Array,
            default: () => [],
            required: true,
        },
        type: {
            type: String,
            default: 'terms',
            required: true,
        },
        column: {
            type: Number,
            default: 4,
        },
        style: {
            type: [String, Object],
            default: undefined,
        },
        class: {
            type: String,
            default: '',
        },
        labelWidth: {
            type: Number,
            default: 40,
        },
    },
    emits: ["search"],
    setup(__props, { emit }) {
        const props = __props;
        const columnOptionMap = new Map();
        // 当前查询条件
        const terms = reactive({ terms: [] });
        const searchItems = ref([]); // 当前查询条件列表
        const itemValueChange = (value, index) => {
            set(terms.terms, [index], value);
        };
        const handleItems = (reset = false) => {
            searchItems.value = [];
            terms.terms = [];
            columnOptionMap.clear();
            let hasSearch = false;
            props.columns.forEach((item, index) => {
                if (item.search && Object.keys(item.search).length) {
                    columnOptionMap.set(item.dataIndex, item.search);
                    // 默认值
                    const { search } = item;
                    let defaultTerms = null;
                    // 包含defaultValue 或者 defaultOnceValue
                    if (search.defaultValue !== undefined ||
                        search.defaultTermType ||
                        search.defaultOnceValue) {
                        const _value = search.defaultValue || reset
                            ? undefined
                            : search.defaultOnceValue;
                        defaultTerms = {
                            column: item.dataIndex,
                            termType: search.defaultTermType || 'like',
                            type: 'and',
                            value: _value,
                        };
                    }
                    if (search.defaultValue !== undefined || search.defaultOnceValue !== undefined) {
                        hasSearch = true;
                    }
                    terms.terms.push(defaultTerms);
                    searchItems.value.push({
                        ...item.search,
                        sortIndex: item.search.first ? 0 : index + 1,
                        title: item.title,
                        column: item.dataIndex,
                    });
                }
            });
            if (hasSearch) {
                searchSubmit();
            }
        };
        /**
         * 提交
         */
        const searchSubmit = () => {
            emit('search', termsParamsFormat(terms.terms, columnOptionMap, 'low', props.type));
        };
        /**
         * 重置查询
         */
        const resetNumber = ref(1);
        const reset = () => {
            resetNumber.value += 1;
            handleItems(true);
            if (props.type == 'object') {
                emit('search', {});
            }
            else if (props.type == 'terms') {
                emit('search', []);
            }
        };
        handleItems();
        return (_ctx, _cache) => {
            return (_openBlock(), _createBlock(_unref(Form), {
                model: terms,
                onFinish: searchSubmit
            }, {
                default: _withCtx(() => [
                    _createElementVNode("div", {
                        class: _normalizeClass(['JSearch-warp', props.class]),
                        style: _normalizeStyle(__props.style)
                    }, [
                        _createElementVNode("div", _hoisted_1, [
                            _createElementVNode("div", _hoisted_2, [
                                _createVNode(_unref(JRow), { gutter: [16, 16] }, {
                                    default: _withCtx(() => [
                                        (_openBlock(true), _createElementBlock(_Fragment, null, _renderList(searchItems.value, (item, index) => {
                                            return (_openBlock(), _createBlock(_unref(JCol), {
                                                key: index + '_' + item.column,
                                                span: item.span || 24 / __props.column
                                            }, {
                                                default: _withCtx(() => [
                                                    _createVNode(SearchItem, {
                                                        "only-value": true,
                                                        expand: false,
                                                        index: index + 1,
                                                        columns: [item],
                                                        "component-props": item.componentProps,
                                                        "terms-item": terms.terms[index],
                                                        reset: resetNumber.value,
                                                        "label-width": __props.labelWidth,
                                                        onChange: (v) => itemValueChange(v, index)
                                                    }, null, 8 /* PROPS */, ["index", "columns", "component-props", "terms-item", "reset", "label-width", "onChange"])
                                                ]),
                                                _: 2 /* DYNAMIC */
                                            }, 1032 /* PROPS, DYNAMIC_SLOTS */, ["span"]));
                                        }), 128 /* KEYED_FRAGMENT */)),
                                        _createVNode(_unref(JCol), {
                                            span: 24 / __props.column
                                        }, {
                                            default: _withCtx(() => [
                                                _createElementVNode("div", {
                                                    class: "JSearch-footer--btns",
                                                    style: _normalizeStyle({ paddingLeft: `${__props.labelWidth + 8}px` })
                                                }, [
                                                    _createVNode(_unref(JButton), {
                                                        type: "stroke",
                                                        onClick: reset
                                                    }, {
                                                        default: _withCtx(() => [
                                                            _createTextVNode(" 重置 ")
                                                        ]),
                                                        _: 1 /* STABLE */
                                                    }),
                                                    _createVNode(_unref(FormItemRest), null, {
                                                        default: _withCtx(() => [
                                                            _createVNode(_unref(JButton), {
                                                                "html-type": "submit",
                                                                type: "primary"
                                                            }, {
                                                                default: _withCtx(() => [
                                                                    _createTextVNode(" 搜索 ")
                                                                ]),
                                                                _: 1 /* STABLE */
                                                            })
                                                        ]),
                                                        _: 1 /* STABLE */
                                                    })
                                                ], 4 /* STYLE */)
                                            ]),
                                            _: 1 /* STABLE */
                                        }, 8 /* PROPS */, ["span"])
                                    ]),
                                    _: 1 /* STABLE */
                                })
                            ])
                        ])
                    ], 6 /* CLASS, STYLE */)
                ]),
                _: 1 /* STABLE */
            }, 8 /* PROPS */, ["model"]));
        };
    }
});
export default __sfc_main__;