function _optionalChain(ops) { let lastAccessLHS = undefined; let value = ops[0]; let i = 1; while (i < ops.length) {
    const op = ops[i];
    const fn = ops[i + 1];
    i += 2;
    if ((op === 'optionalAccess' || op === 'optionalCall') && value == null) {
        return undefined;
    }
    if (op === 'access' || op === 'optionalAccess') {
        lastAccessLHS = value;
        value = fn(value);
    }
    else if (op === 'call' || op === 'optionalCall') {
        value = fn((...args) => value.call(lastAccessLHS, ...args));
        lastAccessLHS = undefined;
    }
} return value; }
/* Analyzed bindings: {
  "columns": "props",
  "index": "props",
  "expand": "props",
  "termsItem": "props",
  "componentProps": "props",
  "onlyValue": "props",
  "reset": "setup-const",
  "labelWidth": "props",
  "typeOptions": "setup-maybe-ref",
  "termType": "setup-maybe-ref",
  "componentType": "setup-maybe-ref",
  "ref": "setup-const",
  "reactive": "setup-const",
  "watchEffect": "setup-const",
  "cloneDeep": "setup-maybe-ref",
  "isArray": "setup-maybe-ref",
  "isFunction": "setup-maybe-ref",
  "omit": "setup-maybe-ref",
  "filterTreeSelectNode": "setup-maybe-ref",
  "filterSelectNode": "setup-maybe-ref",
  "JTreeSelect": "setup-maybe-ref",
  "JSelect": "setup-maybe-ref",
  "JInput": "setup-maybe-ref",
  "JInputNumber": "setup-maybe-ref",
  "JDatePicker": "setup-maybe-ref",
  "JTimePicker": "setup-maybe-ref",
  "JInputPassword": "setup-maybe-ref",
  "JRangePicker": "setup-maybe-ref",
  "JTimeRangePicker": "setup-maybe-ref",
  "FormItem": "setup-maybe-ref",
  "props": "setup-reactive-const",
  "emit": "setup-const",
  "termsModel": "setup-reactive-const",
  "component": "setup-ref",
  "componentName": "setup-ref",
  "cProps": "setup-ref",
  "options": "setup-ref",
  "columnOptions": "setup-ref",
  "columnOptionMap": "setup-maybe-ref",
  "termTypeOptions": "setup-reactive-const",
  "optionLoading": "setup-ref",
  "getTermType": "setup-const",
  "getComponent": "setup-const",
  "removeOptionByKey": "setup-const",
  "handleItemOptions": "setup-const",
  "columnChange": "setup-const",
  "handleItem": "setup-const",
  "termTypeChange": "setup-const",
  "valueChange": "setup-const"
} */
import { defineComponent as _defineComponent } from 'vue';
import { unref as _unref, openBlock as _openBlock, createBlock as _createBlock, createCommentVNode as _createCommentVNode, toDisplayString as _toDisplayString, createElementBlock as _createElementBlock, createVNode as _createVNode, Fragment as _Fragment, normalizeStyle as _normalizeStyle, mergeProps as _mergeProps, resolveDynamicComponent as _resolveDynamicComponent, withCtx as _withCtx, createElementVNode as _createElementVNode } from "vue";
const _hoisted_1 = { class: "JSearch-item" };
const _hoisted_2 = {
    key: 0,
    class: "JSearch-item--type"
};
const _hoisted_3 = { key: 1 };
const _hoisted_4 = { class: "JSearch-item--value" };
import { typeOptions, termType, componentType } from './setting';
import { ref, reactive, watchEffect } from 'vue';
import { cloneDeep, isArray, isFunction, omit } from 'lodash-es';
import { filterTreeSelectNode, filterSelectNode } from './util';
import { TreeSelect as JTreeSelect, Select as JSelect, Input as JInput, InputNumber as JInputNumber, DatePicker as JDatePicker, TimePicker as JTimePicker, InputPassword as JInputPassword, RangePicker as JRangePicker, TimeRangePicker as JTimeRangePicker, FormItem, } from '../components';
const __sfc_main__ = /*#__PURE__*/ _defineComponent({
    props: {
        columns: {
            type: Array,
            default: () => [],
            required: true,
        },
        index: {
            type: Number,
            default: 1,
        },
        expand: {
            type: Boolean,
            default: false,
        },
        termsItem: {
            type: Object,
            default: () => ({}),
        },
        componentProps: {
            type: Object,
            default: () => ({}),
        },
        onlyValue: {
            type: Boolean,
            default: false,
        },
        reset: {
            type: Number,
            default: 1,
        },
        labelWidth: {
            type: Number,
            default: 40
        }
    },
    emits: ["change"],
    setup(__props, { emit }) {
        const props = __props;
        const termsModel = reactive({
            type: _optionalChain([props, 'access', _2 => _2.termsItem, 'optionalAccess', _3 => _3.type]) || 'or',
            value: _optionalChain([props, 'access', _4 => _4.termsItem, 'optionalAccess', _5 => _5.value]) || '',
            termType: _optionalChain([props, 'access', _6 => _6.termsItem, 'optionalAccess', _7 => _7.termType]) || 'like',
            column: _optionalChain([props, 'access', _8 => _8.termsItem, 'optionalAccess', _9 => _9.column]) || undefined,
        });
        const component = ref(componentType.input);
        const componentName = ref();
        const cProps = ref({});
        const options = ref([]);
        const columnOptions = ref([]);
        const columnOptionMap = new Map();
        const termTypeOptions = reactive({ option: termType });
        const optionLoading = ref(false);
        /**
         * 根据类型切换默termType值
         * @param type
         */
        const getTermType = (type, column) => {
            termTypeOptions.option = termType;
            if (_optionalChain([column, 'optionalAccess', _10 => _10.includes, 'call', _11 => _11('id')]) && type === 'string') {
                // 默认id为 eq
                return 'eq';
            }
            switch (type) {
                case 'select':
                case 'treeSelect':
                case 'number':
                    return 'eq';
                case 'date':
                case 'time':
                    // 时间只有大于或小于两个值
                    termTypeOptions.option = termType.filter((item) => ['gt', 'lt'].includes(item.value));
                    return 'gt';
                case 'timeRange':
                case 'rangePicker':
                    termTypeOptions.option = termType.filter((item) => ['btw', 'nbtw'].includes(item.value));
                    return 'btw';
                default:
                    return 'like';
            }
        };
        /**
         * 根据类型返回组件
         * @param type
         */
        const getComponent = (type) => {
            switch (type) {
                case 'select':
                    component.value = componentType.select;
                    break;
                case 'treeSelect':
                    component.value = componentType.treeSelect;
                    break;
                case 'date':
                    component.value = componentType.date;
                    break;
                case 'time':
                    component.value = componentType.time;
                    break;
                case 'number':
                    component.value = componentType.inputNumber;
                    break;
                case 'timeRange':
                    component.value = componentType.timeRange;
                    break;
                case 'rangePicker':
                    component.value = componentType.rangePicker;
                    break;
                case 'component':
                    component.value = componentType.component;
                    break;
                default:
                    component.value = componentType.input;
                    break;
            }
        };
        const removeOptionByKey = (options) => {
            return options.map((item) => {
                if (item.children) {
                    item.children = removeOptionByKey(item.children);
                }
                return omit(item, ['key']);
            });
        };
        const handleItemOptions = (option) => {
            options.value = [];
            if (isArray(option)) {
                options.value = option;
            }
            else if (isFunction(option)) {
                optionLoading.value = true;
                option()
                    .then((res) => {
                    optionLoading.value = false;
                    options.value = removeOptionByKey(res);
                })
                    .catch((_) => {
                    optionLoading.value = false;
                });
            }
        };
        const columnChange = (value, isChange, changeValue = true) => {
            const item = columnOptionMap.get(value);
            if (!item)
                return;
            cProps.value = item.componentProps;
            optionLoading.value = false;
            // 设置value为undefined
            termsModel.column = value;
            getComponent(item.type); // 处理Item的组件类型
            componentName.value = item.components;
            // 处理options 以及 request
            if ('options' in item) {
                handleItemOptions(item.options);
            }
            if (changeValue) {
                termsModel.value = undefined;
                termsModel.termType =
                    item.defaultTermType || getTermType(item.type, value);
            }
            if (isChange) {
                valueChange();
            }
        };
        const handleItem = () => {
            columnOptionMap.clear();
            columnOptions.value = [];
            if (!props.columns.length)
                return;
            columnOptions.value = props.columns.map((item) => {
                // 对columns进行Map处理以及值处理
                columnOptionMap.set(item.column, item);
                return {
                    label: item.title,
                    value: item.column,
                };
            });
            if (!props.onlyValue) {
                // 获取第一个值
                const sortColumn = cloneDeep(props.columns);
                _optionalChain([sortColumn, 'optionalAccess', _12 => _12.sort, 'call', _13 => _13((a, b) => a.sortIndex - b.sortIndex)]);
                const _index = props.index > sortColumn.length
                    ? sortColumn.length - 1
                    : props.index;
                if (props.index <= sortColumn.length) {
                    const _itemColumn = sortColumn[_index - 1];
                    columnChange(_itemColumn.column, false);
                }
            }
            else {
                columnChange(_optionalChain([props, 'access', _14 => _14.columns, 'access', _15 => _15[0], 'optionalAccess', _16 => _16.column]), false);
            }
        };
        const termTypeChange = () => {
            valueChange();
        };
        const valueChange = () => {
            emit('change', {
                type: props.onlyValue ? 'and' : termsModel.type,
                value: termsModel.value,
                termType: termsModel.termType || 'like',
                column: termsModel.column,
            });
        };
        const reset = () => {
            termsModel.value = undefined;
        };
        handleItem();
        watchEffect(() => {
            if (props.termsItem) {
                Object.keys(props.termsItem).forEach((key) => {
                    if (key === 'column' && props.termsItem[key] !== termsModel[key]) {
                        columnChange(props.termsItem[key], false, false);
                    }
                    termsModel[key] = props.termsItem[key];
                });
            }
            else {
                handleItem();
            }
        });
        return (_ctx, _cache) => {
            return (_openBlock(), _createElementBlock("div", _hoisted_1, [
                (!__props.onlyValue)
                    ? (_openBlock(), _createElementBlock(_Fragment, { key: 0 }, [
                        (__props.expand)
                            ? (_openBlock(), _createElementBlock("div", _hoisted_2, [
                                (__props.index !== 1 && __props.index !== 4)
                                    ? (_openBlock(), _createBlock(_unref(JSelect), {
                                        key: 0,
                                        value: termsModel.type,
                                        "onUpdate:value": _cache[0] || (_cache[0] = ($event) => ((termsModel.type) = $event)),
                                        options: _unref(typeOptions),
                                        style: { "width": "100%" },
                                        onChange: valueChange
                                    }, null, 8 /* PROPS */, ["value", "options"]))
                                    : (_openBlock(), _createElementBlock("span", _hoisted_3, _toDisplayString(__props.index === 1 ? '第一组' : '第二组'), 1 /* TEXT */))
                            ]))
                            : _createCommentVNode("v-if", true),
                        _createVNode(_unref(JSelect), {
                            value: termsModel.column,
                            "onUpdate:value": _cache[1] || (_cache[1] = ($event) => ((termsModel.column) = $event)),
                            placeholder: "请选择",
                            class: "JSearch-item--column",
                            options: columnOptions.value,
                            onChange: columnChange
                        }, null, 8 /* PROPS */, ["value", "options"]),
                        _createVNode(_unref(JSelect), {
                            value: termsModel.termType,
                            "onUpdate:value": _cache[2] || (_cache[2] = ($event) => ((termsModel.termType) = $event)),
                            placeholder: "请选择",
                            class: "JSearch-item--termType",
                            options: termTypeOptions.option,
                            onChange: termTypeChange
                        }, null, 8 /* PROPS */, ["value", "options"])
                    ], 64 /* STABLE_FRAGMENT */))
                    : (_openBlock(), _createElementBlock("div", {
                        key: 1,
                        class: "JSearch-item--label",
                        style: _normalizeStyle({ minWidth: `${__props.labelWidth}px` })
                    }, _toDisplayString(_optionalChain([columnOptions, 'access', _17 => _17.value, 'access', _18 => _18[0], 'optionalAccess', _19 => _19.label])), 5 /* TEXT, STYLE */)),
                _createElementVNode("div", _hoisted_4, [
                    _createVNode(_unref(FormItem), { "no-style": "" }, {
                        default: _withCtx(() => [
                            (component.value === _unref(componentType).input)
                                ? (_openBlock(), _createBlock(_unref(JInput), _mergeProps({ key: 0 }, cProps.value, {
                                    value: termsModel.value,
                                    "onUpdate:value": _cache[3] || (_cache[3] = ($event) => ((termsModel.value) = $event)),
                                    "allow-clear": "",
                                    style: { "width": "100%" },
                                    onChange: valueChange
                                }), null, 16 /* FULL_PROPS */, ["value"]))
                                : (component.value === _unref(componentType).select)
                                    ? (_openBlock(), _createBlock(_unref(JSelect), _mergeProps({ key: 1 }, cProps.value, {
                                        value: termsModel.value,
                                        "onUpdate:value": _cache[4] || (_cache[4] = ($event) => ((termsModel.value) = $event)),
                                        "allow-clear": "",
                                        style: { "width": "100%", "min-width": "80px" },
                                        "show-search": "",
                                        loading: optionLoading.value,
                                        options: options.value,
                                        "filter-option": (v, option) => _unref(filterSelectNode)(v, option, 'label'),
                                        onChange: valueChange
                                    }), null, 16 /* FULL_PROPS */, ["value", "loading", "options", "filter-option"]))
                                    : (component.value === _unref(componentType).inputNumber)
                                        ? (_openBlock(), _createBlock(_unref(JInputNumber), _mergeProps({ key: 2 }, cProps.value, {
                                            value: termsModel.value,
                                            "onUpdate:value": _cache[5] || (_cache[5] = ($event) => ((termsModel.value) = $event)),
                                            "allow-clear": "",
                                            style: { "width": "100%" },
                                            onChange: valueChange
                                        }), null, 16 /* FULL_PROPS */, ["value"]))
                                        : (component.value === _unref(componentType).password)
                                            ? (_openBlock(), _createBlock(_unref(JInputPassword), _mergeProps({ key: 3 }, cProps.value, {
                                                value: termsModel.value,
                                                "onUpdate:value": _cache[6] || (_cache[6] = ($event) => ((termsModel.value) = $event)),
                                                "allow-clear": "",
                                                style: { "width": "100%" },
                                                onChange: valueChange
                                            }), null, 16 /* FULL_PROPS */, ["value"]))
                                            : (component.value === _unref(componentType).time)
                                                ? (_openBlock(), _createBlock(_unref(JTimePicker), _mergeProps({
                                                    key: 4,
                                                    value: termsModel.value,
                                                    "onUpdate:value": _cache[7] || (_cache[7] = ($event) => ((termsModel.value) = $event)),
                                                    "allow-clear": "",
                                                    "value-format": "HH:mm:ss",
                                                    style: { "width": "100%" }
                                                }, cProps.value, { onChange: valueChange }), null, 16 /* FULL_PROPS */, ["value"]))
                                                : (component.value === _unref(componentType).timeRange)
                                                    ? (_openBlock(), _createBlock(_unref(JTimeRangePicker), _mergeProps({
                                                        key: 5,
                                                        value: termsModel.value,
                                                        "onUpdate:value": _cache[8] || (_cache[8] = ($event) => ((termsModel.value) = $event)),
                                                        "allow-clear": "",
                                                        "value-format": "HH:mm:ss",
                                                        style: { "width": "100%" }
                                                    }, cProps.value, { onChange: valueChange }), null, 16 /* FULL_PROPS */, ["value"]))
                                                    : (component.value === _unref(componentType).date)
                                                        ? (_openBlock(), _createBlock(_unref(JDatePicker), _mergeProps({
                                                            key: 6,
                                                            value: termsModel.value,
                                                            "onUpdate:value": _cache[9] || (_cache[9] = ($event) => ((termsModel.value) = $event)),
                                                            "allow-clear": "",
                                                            "show-time": "",
                                                            "value-format": "YYYY-MM-DD HH:mm:ss",
                                                            style: { "width": "100%" }
                                                        }, cProps.value, { onChange: valueChange }), null, 16 /* FULL_PROPS */, ["value"]))
                                                        : (component.value === _unref(componentType).rangePicker)
                                                            ? (_openBlock(), _createBlock(_unref(JRangePicker), _mergeProps({
                                                                key: 7,
                                                                value: termsModel.value,
                                                                "onUpdate:value": _cache[10] || (_cache[10] = ($event) => ((termsModel.value) = $event)),
                                                                "allow-clear": "",
                                                                "show-time": "",
                                                                "value-format": "YYYY-MM-DD HH:mm:ss",
                                                                style: { "width": "100%" }
                                                            }, cProps.value, { onChange: valueChange }), null, 16 /* FULL_PROPS */, ["value"]))
                                                            : (component.value === _unref(componentType).treeSelect)
                                                                ? (_openBlock(), _createBlock(_unref(JTreeSelect), _mergeProps({
                                                                    key: 8,
                                                                    value: termsModel.value,
                                                                    "onUpdate:value": _cache[11] || (_cache[11] = ($event) => ((termsModel.value) = $event)),
                                                                    "allow-clear": "",
                                                                    "show-search": "",
                                                                    style: { "width": "100%" },
                                                                    height: 350,
                                                                    "field-names": { label: 'name', value: 'id' }
                                                                }, cProps.value, {
                                                                    "tree-data": options.value,
                                                                    "filter-tree-node": (v, option) => _unref(filterTreeSelectNode)(v, option),
                                                                    onChange: valueChange
                                                                }), null, 16 /* FULL_PROPS */, ["value", "tree-data", "filter-tree-node"]))
                                                                : (component.value === _unref(componentType).component && componentName.value)
                                                                    ? (_openBlock(), _createBlock(_resolveDynamicComponent(componentName.value), _mergeProps({
                                                                        key: 9,
                                                                        value: termsModel.value,
                                                                        "onUpdate:value": _cache[12] || (_cache[12] = ($event) => ((termsModel.value) = $event))
                                                                    }, cProps.value, { onChange: valueChange }), null, 16 /* FULL_PROPS */, ["value"]))
                                                                    : _createCommentVNode("v-if", true)
                        ]),
                        _: 1 /* STABLE */
                    })
                ])
            ]));
        };
    }
});
export default __sfc_main__;