/* Analyzed bindings: {
  "value": "props"
} */
import { ref } from 'vue';
const __sfc_main__ = {
    name: "Custom",
    props: {
        value: {
            type: String,
            default: undefined
        }
    },
    emits: ['update:value', 'change'],
    setup: (props, { emit }) => {
        const myValue = ref(props.value);
        const change = (e) => {
            myValue.value = e.target.value;
            emit('update:value', myValue.value);
            emit('change');
        };
        return {
            myValue,
            change
        };
    }
};
export default __sfc_main__;