/* Analyzed bindings: {
  "columns": "setup-maybe-ref",
  "paramsStr": "setup-maybe-ref",
  "onSearch": "setup-maybe-ref",
  "value": "setup-maybe-ref"
} */
import { ref } from 'vue';
const __sfc_main__ = {
    name: 'Basic',
    setup() {
        const paramsStr = ref();
        const value = ref('terms');
        const columns = [
            {
                title: '名称名称名称1',
                dataIndex: 'name',
                search: {
                    type: 'string',
                    componentProps: {
                        placeholder: '请输入名称',
                    },
                    defaultOnceValue: '123123',
                },
            },
            {
                title: '年龄',
                dataIndex: 'age',
                search: {
                    type: 'number',
                    componentProps: {
                        placeholder: '请输入真实年龄',
                    },
                },
            },
            {
                title: '类型',
                dataIndex: 'type',
                search: {
                    type: 'select',
                    options: [
                        { label: '类型1', value: 1 },
                        { label: '类型2', value: 2 },
                    ],
                    componentProps: {
                        placeholder: '请选择类型',
                    },
                },
            },
            {
                title: '测试地址长度',
                dataIndex: 'address',
                search: {
                    type: 'string',
                },
            },
            {
                title: '时间',
                dataIndex: 'time',
                search: {
                    type: 'timeRange',
                },
            },
        ];
        const onSearch = (e) => {
            paramsStr.value = JSON.stringify(e);
        };
        return {
            columns,
            paramsStr,
            onSearch,
            value,
        };
    },
};
export default __sfc_main__;