/* Analyzed bindings: {
  "columns": "setup-maybe-ref",
  "paramsStr": "setup-maybe-ref",
  "onSearch": "setup-maybe-ref",
  "deleteRequest": "setup-maybe-ref"
} */
import { ref } from 'vue';
const __sfc_main__ = {
    name: 'AdvancedSearch',
    setup() {
        const paramsStr = ref();
        const columns = [
            {
                title: '名称',
                dataIndex: 'name',
                search: {
                    type: 'string',
                    componentProps: {
                        placeholder: '请输入名称',
                    },
                },
            },
            {
                title: '年龄',
                dataIndex: 'age',
                search: {
                    type: 'number',
                    componentProps: {
                        placeholder: '请输入真实年龄',
                    },
                },
            },
            {
                title: '类型',
                dataIndex: 'type',
                search: {
                    type: 'select',
                    rename: 'typeTest',
                    options: [
                        { label: '类型1', value: 1 },
                        { label: '类型2', value: 2 },
                    ],
                },
            },
            {
                title: '类型2',
                dataIndex: 'type2',
                search: {
                    type: 'select',
                    options: [
                        { label: '类型1', value: 1 },
                        { label: '类型2', value: 2 },
                    ],
                },
            },
        ];
        const onSearch = (e) => {
            paramsStr.value = JSON.stringify(e);
        };
        const deleteRequest = async (id) => {
            console.log(id);
        };
        return {
            columns,
            paramsStr,
            onSearch,
            deleteRequest,
        };
    },
};
export default __sfc_main__;