function _optionalChain(ops) { let lastAccessLHS = undefined; let value = ops[0]; let i = 1; while (i < ops.length) {
    const op = ops[i];
    const fn = ops[i + 1];
    i += 2;
    if ((op === 'optionalAccess' || op === 'optionalCall') && value == null) {
        return undefined;
    }
    if (op === 'access' || op === 'optionalAccess') {
        lastAccessLHS = value;
        value = fn(value);
    }
    else if (op === 'call' || op === 'optionalCall') {
        value = fn((...args) => value.call(lastAccessLHS, ...args));
        lastAccessLHS = undefined;
    }
} return value; }
/* Analyzed bindings: {
  "columns": "props",
  "type": "props",
  "target": "setup-maybe-ref",
  "class": "props",
  "request": "props",
  "historyRequest": "props",
  "deleteRequest": "props",
  "deleteKey": "props",
  "routerMode": "props",
  "style": "props",
  "SearchItem": "setup-const",
  "typeOptions": "setup-maybe-ref",
  "useElementSize": "setup-maybe-ref",
  "useRouteQuery": "setup-maybe-ref",
  "PropType": "setup-const",
  "ref": "setup-const",
  "reactive": "setup-const",
  "watch": "setup-const",
  "SaveHistory": "setup-const",
  "History": "setup-const",
  "compatibleOldTerms": "setup-maybe-ref",
  "handleQData": "setup-maybe-ref",
  "hasExpand": "setup-maybe-ref",
  "termsParamsFormat": "setup-maybe-ref",
  "JSelect": "setup-maybe-ref",
  "JButton": "setup-maybe-ref",
  "AIcon": "setup-maybe-ref",
  "Form": "setup-maybe-ref",
  "FormItemRest": "setup-maybe-ref",
  "props": "setup-reactive-const",
  "searchRef": "setup-ref",
  "searchRefContentRef": "setup-ref",
  "width": "setup-maybe-ref",
  "q": "setup-maybe-ref",
  "expand": "setup-ref",
  "layout": "setup-ref",
  "compatible": "setup-ref",
  "screenSize": "setup-ref",
  "resetNumber": "setup-ref",
  "searchItems": "setup-ref",
  "termsData": "setup-reactive-const",
  "columnOptionMap": "setup-maybe-ref",
  "emit": "setup-const",
  "expandChange": "setup-const",
  "searchParams": "setup-reactive-const",
  "itemValueChange": "setup-const",
  "addUrlParams": "setup-const",
  "searchSubmit": "setup-const",
  "reset": "setup-const",
  "historyItemClick": "setup-const",
  "handleUrlParams": "setup-const",
  "handleItems": "setup-const"
} */
import { defineComponent as _defineComponent } from 'vue';
import { createCommentVNode as _createCommentVNode, createVNode as _createVNode, openBlock as _openBlock, createBlock as _createBlock, createElementVNode as _createElementVNode, unref as _unref, createElementBlock as _createElementBlock, renderList as _renderList, Fragment as _Fragment, normalizeClass as _normalizeClass, createTextVNode as _createTextVNode, withCtx as _withCtx, normalizeStyle as _normalizeStyle } from "vue";
const _hoisted_1 = { class: "left" };
const _hoisted_2 = { class: "left-items" };
const _hoisted_3 = {
    key: 0,
    class: "center"
};
const _hoisted_4 = {
    key: 1,
    class: "right"
};
const _hoisted_5 = { class: "right-items" };
const _hoisted_6 = { class: "JSearch-footer--btns" };
const _hoisted_7 = /*#__PURE__*/ _createElementVNode("span", { class: "more-text" }, " 更多筛选 ", -1 /* HOISTED */);
const _hoisted_8 = { class: "JSearch-content single big pack-up" };
const _hoisted_9 = { class: "JSearch-items" };
const _hoisted_10 = { class: "left" };
const _hoisted_11 = { class: "JSearch-footer" };
const _hoisted_12 = { class: "JSearch-footer--btns" };
import SearchItem from '../Item.js';
import { typeOptions } from '../setting';
import { useElementSize } from '@vueuse/core';
import { useRouteQuery } from '@vueuse/router';
import { ref, reactive, watch } from 'vue';
import SaveHistory from './SaveHistory.js';
import History from './History.js';
import { compatibleOldTerms, handleQData, hasExpand, termsParamsFormat, } from '../util';
import { Select as JSelect, Button as JButton, AIcon, Form, FormItemRest, } from '../../components';
const __sfc_main__ = /*#__PURE__*/ _defineComponent({
    props: {
        columns: {
            type: Array,
            default: () => [],
            required: true,
        },
        type: {
            type: String,
            default: 'advanced',
        },
        target: {
            type: String,
            default: '',
            required: true,
        },
        class: {
            type: String,
            default: '',
        },
        request: {
            type: Function,
            default: undefined,
        },
        historyRequest: {
            type: Function,
            default: undefined,
        },
        deleteRequest: {
            type: Function,
            default: null,
        },
        deleteKey: {
            type: String,
            default: 'key',
        },
        routerMode: {
            type: String,
            default: 'hash',
        },
        style: {
            type: [String, Object],
            default: undefined,
        },
    },
    emits: ["search"],
    setup(__props, { emit }) {
        const props = __props;
        const searchRef = ref(null);
        const searchRefContentRef = ref(null);
        const { width } = useElementSize(searchRef);
        const q = useRouteQuery('q');
        const target = useRouteQuery('target');
        // 是否展开更多筛选
        const expand = ref(false);
        // 组件方向
        const layout = ref('horizontal');
        const compatible = ref(false);
        // 当前组件宽度 true 大于1000
        const screenSize = ref(true);
        const resetNumber = ref(1);
        const searchItems = ref([]); // 当前查询条件
        const termsData = reactive({
            terms: [
                { terms: [null, null, null] },
                { terms: [null, null, null], type: 'and' },
            ],
        });
        const columnOptionMap = new Map();
        const expandChange = () => {
            expand.value = !expand.value;
            if (!expand.value) {
                // 收起
                const firstItem = termsData.terms[0].terms[0];
                termsData.terms = [
                    { terms: [firstItem, null, null] },
                    { terms: [null, null, null] },
                ];
            }
        };
        const searchParams = reactive({
            data: {},
        });
        const itemValueChange = (value, index) => {
            if (index < 4) {
                // 第一组数据
                termsData.terms[0].terms[index - 1] = value;
            }
            else {
                // 第二组数据
                termsData.terms[1].terms[index - 4] = value;
            }
        };
        const addUrlParams = () => {
            q.value = JSON.stringify(termsData);
            target.value = props.target;
        };
        /**
         * 提交
         */
        const searchSubmit = () => {
            emit('search', termsParamsFormat(termsData, columnOptionMap));
            if (props.type === 'advanced') {
                addUrlParams();
            }
        };
        /**
         * 重置查询
         */
        const reset = () => {
            termsData.terms = [
                { terms: [null, null, null] },
                { terms: [null, null, null], type: 'and' },
            ];
            expand.value = false;
            if (props.type === 'advanced') {
                q.value = null;
                target.value = null;
            }
            resetNumber.value += 1;
            emit('search', { terms: [] });
        };
        watch(width, (value) => {
            if (value < 1000) {
                layout.value = 'vertical';
                screenSize.value = false;
                compatible.value = value < 760;
            }
            else {
                layout.value = 'horizontal';
                screenSize.value = true;
                compatible.value = false;
            }
        }, { immediate: true });
        const historyItemClick = (content) => {
            try {
                termsData.terms = _optionalChain([handleQData, 'call', _2 => _2(compatibleOldTerms(content)), 'optionalAccess', _3 => _3.terms]) || [];
                expand.value = hasExpand(termsData.terms);
                searchSubmit();
            }
            catch (e) {
                console.warn(`Search组件中handleUrlParams处理JSON时异常：【${e}】`);
            }
        };
        /**
         * 处理URL中的查询参数
         * @param _params
         */
        const handleUrlParams = (_params) => {
            // URL中的target和props的一致，则还原查询参数
            if (props.target && _params.target === props.target && _params.q) {
                termsData.terms =
                    _optionalChain([handleQData, 'call', _4 => _4(compatibleOldTerms(_params.q)), 'optionalAccess', _5 => _5.terms]) || [];
                expand.value = hasExpand(termsData.terms);
                emit('search', termsParamsFormat(termsData, columnOptionMap));
            }
        };
        /**
         * 处理每项的key为Item组件所需要的key
         */
        const handleItems = () => {
            searchItems.value = [];
            columnOptionMap.clear();
            props.columns.forEach((item, index) => {
                if (item.search && Object.keys(item.search).length) {
                    columnOptionMap.set(_optionalChain([item, 'access', _6 => _6.search, 'optionalAccess', _7 => _7.rename]) || item.dataIndex, item.search);
                    searchItems.value.push({
                        ...item.search,
                        sortIndex: item.search.first ? 0 : index + 1,
                        title: item.title,
                        column: _optionalChain([item, 'access', _8 => _8.search, 'optionalAccess', _9 => _9.rename]) || item.dataIndex,
                    });
                }
            });
            handleUrlParams({ q: q.value, target: target.value });
        };
        handleItems();
        return (_ctx, _cache) => {
            return (_openBlock(), _createBlock(_unref(Form), {
                model: termsData,
                onFinish: searchSubmit
            }, {
                default: _withCtx(() => [
                    _createElementVNode("div", {
                        ref_key: "searchRef",
                        ref: searchRef,
                        class: _normalizeClass(['JSearch-warp', 'senior', props.class]),
                        style: _normalizeStyle(__props.style)
                    }, [
                        _createCommentVNode("  高级模式  "),
                        (props.type === 'advanced')
                            ? (_openBlock(), _createElementBlock("div", {
                                key: 0,
                                ref_key: "searchRefContentRef",
                                ref: searchRefContentRef,
                                class: _normalizeClass([
                                    'JSearch-content',
                                    expand.value || compatible.value ? 'senior-expand' : 'pack-up',
                                    screenSize.value ? 'big' : 'small',
                                ])
                            }, [
                                _createElementVNode("div", {
                                    class: _normalizeClass([
                                        'JSearch-items',
                                        expand.value ? 'items-expand' : '',
                                        layout.value,
                                    ])
                                }, [
                                    _createElementVNode("div", _hoisted_1, [
                                        _createElementVNode("div", _hoisted_2, [
                                            _createVNode(SearchItem, {
                                                expand: expand.value,
                                                index: 1,
                                                columns: searchItems.value,
                                                "terms-item": termsData.terms[0].terms[0],
                                                reset: resetNumber.value,
                                                onChange: _cache[0] || (_cache[0] = (v) => itemValueChange(v, 1))
                                            }, null, 8 /* PROPS */, ["expand", "columns", "terms-item", "reset"]),
                                            (expand.value)
                                                ? (_openBlock(), _createBlock(SearchItem, {
                                                    key: 0,
                                                    expand: expand.value,
                                                    index: 2,
                                                    columns: searchItems.value,
                                                    "terms-item": termsData.terms[0].terms[1],
                                                    reset: resetNumber.value,
                                                    onChange: _cache[1] || (_cache[1] = (v) => itemValueChange(v, 2))
                                                }, null, 8 /* PROPS */, ["expand", "columns", "terms-item", "reset"]))
                                                : _createCommentVNode("v-if", true),
                                            (expand.value)
                                                ? (_openBlock(), _createBlock(SearchItem, {
                                                    key: 1,
                                                    expand: expand.value,
                                                    index: 3,
                                                    columns: searchItems.value,
                                                    "terms-item": termsData.terms[0].terms[2],
                                                    reset: resetNumber.value,
                                                    onChange: _cache[2] || (_cache[2] = (v) => itemValueChange(v, 3))
                                                }, null, 8 /* PROPS */, ["expand", "columns", "terms-item", "reset"]))
                                                : _createCommentVNode("v-if", true)
                                        ])
                                    ]),
                                    (expand.value)
                                        ? (_openBlock(), _createElementBlock("div", _hoisted_3, [
                                            _createVNode(_unref(JSelect), {
                                                value: termsData.terms[1].type,
                                                "onUpdate:value": _cache[3] || (_cache[3] = ($event) => ((termsData.terms[1].type) = $event)),
                                                class: "center-select",
                                                style: { "width": "100px" },
                                                options: _unref(typeOptions)
                                            }, null, 8 /* PROPS */, ["value", "options"])
                                        ]))
                                        : _createCommentVNode("v-if", true),
                                    (expand.value)
                                        ? (_openBlock(), _createElementBlock("div", _hoisted_4, [
                                            _createElementVNode("div", _hoisted_5, [
                                                (_openBlock(), _createElementBlock(_Fragment, null, _renderList([4, 5, 6], (item) => {
                                                    return _createVNode(SearchItem, {
                                                        key: `search_item_${item}`,
                                                        expand: expand.value,
                                                        index: item,
                                                        columns: searchItems.value,
                                                        "terms-item": termsData.terms[1].terms[item - 4],
                                                        reset: resetNumber.value,
                                                        onChange: (v) => itemValueChange(v, item)
                                                    }, null, 8 /* PROPS */, ["expand", "index", "columns", "terms-item", "reset", "onChange"]);
                                                }), 64 /* STABLE_FRAGMENT */))
                                            ])
                                        ]))
                                        : _createCommentVNode("v-if", true)
                                ], 2 /* CLASS */),
                                _createElementVNode("div", {
                                    class: _normalizeClass([
                                        'JSearch-footer',
                                        expand.value || compatible.value ? 'expand' : '',
                                    ])
                                }, [
                                    _createElementVNode("div", _hoisted_6, [
                                        _createVNode(_unref(JButton), {
                                            type: "stroke",
                                            onClick: reset
                                        }, {
                                            default: _withCtx(() => [
                                                _createTextVNode(" 重置 ")
                                            ]),
                                            _: 1 /* STABLE */
                                        }),
                                        _createVNode(SaveHistory, {
                                            terms: termsData,
                                            target: _unref(target),
                                            request: __props.request
                                        }, null, 8 /* PROPS */, ["terms", "target", "request"]),
                                        _createVNode(History, {
                                            target: _unref(target),
                                            request: __props.historyRequest,
                                            "delete-request": __props.deleteRequest,
                                            "delete-key": __props.deleteKey,
                                            onClick: searchSubmit,
                                            onItemClick: historyItemClick
                                        }, null, 8 /* PROPS */, ["target", "request", "delete-request", "delete-key"])
                                    ]),
                                    _createVNode(_unref(JButton), {
                                        type: "link",
                                        class: "more-btn",
                                        onClick: expandChange
                                    }, {
                                        default: _withCtx(() => [
                                            _hoisted_7,
                                            _createVNode(_unref(AIcon), {
                                                type: "DoubleRightOutlined",
                                                class: _normalizeClass([
                                                    'more-icon',
                                                    expand.value ? 'more-up' : 'more-down',
                                                ])
                                            }, null, 8 /* PROPS */, ["class"])
                                        ]),
                                        _: 1 /* STABLE */
                                    })
                                ], 2 /* CLASS */)
                            ], 2 /* CLASS */))
                            : (_openBlock(), _createElementBlock(_Fragment, { key: 1 }, [
                                _createCommentVNode("  简单模式  "),
                                _createElementVNode("div", _hoisted_8, [
                                    _createElementVNode("div", _hoisted_9, [
                                        _createElementVNode("div", _hoisted_10, [
                                            _createVNode(SearchItem, {
                                                expand: false,
                                                index: 1,
                                                columns: searchItems.value,
                                                "terms-item": termsData.terms[0].terms[0],
                                                reset: resetNumber.value,
                                                onChange: _cache[4] || (_cache[4] = (v) => itemValueChange(v, 1))
                                            }, null, 8 /* PROPS */, ["columns", "terms-item", "reset"])
                                        ])
                                    ]),
                                    _createElementVNode("div", _hoisted_11, [
                                        _createElementVNode("div", _hoisted_12, [
                                            _createVNode(_unref(FormItemRest), null, {
                                                default: _withCtx(() => [
                                                    _createVNode(_unref(JButton), {
                                                        type: "stroke",
                                                        onClick: reset
                                                    }, {
                                                        default: _withCtx(() => [
                                                            _createTextVNode(" 重置 ")
                                                        ]),
                                                        _: 1 /* STABLE */
                                                    }),
                                                    _createVNode(_unref(JButton), {
                                                        "html-type": "submit",
                                                        type: "primary"
                                                    }, {
                                                        default: _withCtx(() => [
                                                            _createTextVNode(" 搜索 ")
                                                        ]),
                                                        _: 1 /* STABLE */
                                                    })
                                                ]),
                                                _: 1 /* STABLE */
                                            })
                                        ])
                                    ])
                                ])
                            ], 2112 /* STABLE_FRAGMENT, DEV_ROOT_FRAGMENT */))
                    ], 6 /* CLASS, STYLE */)
                ]),
                _: 1 /* STABLE */
            }, 8 /* PROPS */, ["model"]));
        };
    }
});
export default __sfc_main__;