/* Analyzed bindings: {
  "terms": "props",
  "target": "props",
  "request": "props",
  "ref": "setup-const",
  "reactive": "setup-const",
  "JForm": "setup-maybe-ref",
  "JButton": "setup-maybe-ref",
  "JFormItem": "setup-maybe-ref",
  "AIcon": "setup-maybe-ref",
  "Popover": "setup-maybe-ref",
  "Textarea": "setup-maybe-ref",
  "message": "setup-maybe-ref",
  "isFunction": "setup-maybe-ref",
  "props": "setup-reactive-const",
  "saveHistoryLoading": "setup-ref",
  "visible": "setup-ref",
  "formRef": "setup-ref",
  "modelRef": "setup-reactive-const",
  "visibleChange": "setup-const",
  "saveHistory": "setup-const"
} */
import { defineComponent as _defineComponent } from 'vue';
import { unref as _unref, createVNode as _createVNode, withCtx as _withCtx, createTextVNode as _createTextVNode, createElementVNode as _createElementVNode, openBlock as _openBlock, createBlock as _createBlock, pushScopeId as _pushScopeId, popScopeId as _popScopeId } from "vue";
const _withScopeId = n => (_pushScopeId("data-v-1683728032070"), n = n(), _popScopeId(), n);
const _hoisted_1 = { style: { "width": "240px" } };
import { ref, reactive } from 'vue';
import { Form as JForm, Button as JButton, FormItem as JFormItem, Popover, Textarea, message, } from '../../components';
import { isFunction } from 'lodash-es';
const __sfc_main__ = /*#__PURE__*/ _defineComponent({
    props: {
        terms: {
            type: Object,
            default: () => ({}),
        },
        target: {
            type: String,
            default: '',
            required: true,
        },
        request: {
            type: Function,
            default: null,
        },
    },
    setup(__props) {
        const props = __props;
        const saveHistoryLoading = ref(false);
        const visible = ref(false);
        const formRef = ref();
        const modelRef = reactive({
            name: undefined,
        });
        const visibleChange = (e) => {
            visible.value = e;
            if (!e) {
                setTimeout(() => {
                    modelRef.name = undefined;
                }, 100);
            }
        };
        /**
         * 保存当前查询条件
         */
        const saveHistory = async () => {
            // 获取当前查询条件并转化为字符串
            const formData = await formRef.value.validate();
            if (formData && props.request && isFunction(props.request)) {
                formData.content = JSON.stringify(props.terms);
                saveHistoryLoading.value = true;
                const resp = await props.request(formData, props.target);
                saveHistoryLoading.value = false;
                if (resp.success || resp.status === 200 || resp.code === 200) {
                    message.success('操作成功');
                    visibleChange(false);
                }
                else {
                    message.error('操作失败');
                }
            }
        };
        return (_ctx, _cache) => {
            return (_openBlock(), _createBlock(_unref(Popover), {
                visible: visible.value,
                "onUpdate:visible": _cache[1] || (_cache[1] = ($event) => ((visible).value = $event)),
                title: "搜索名称",
                trigger: "click",
                placement: "bottom",
                onVisibleChange: visibleChange
            }, {
                content: _withCtx(() => [
                    _createElementVNode("div", _hoisted_1, [
                        _createVNode(_unref(JForm), {
                            ref_key: "formRef",
                            ref: formRef,
                            model: modelRef
                        }, {
                            default: _withCtx(() => [
                                _createVNode(_unref(JFormItem), {
                                    name: "name",
                                    rules: [
                                        { required: true, message: '请输入名称' },
                                        { max: 64, message: '最多64个字符' },
                                    ]
                                }, {
                                    default: _withCtx(() => [
                                        _createVNode(_unref(Textarea), {
                                            value: modelRef.name,
                                            "onUpdate:value": _cache[0] || (_cache[0] = ($event) => ((modelRef.name) = $event)),
                                            rows: 3,
                                            maxlength: 200
                                        }, null, 8 /* PROPS */, ["value"])
                                    ]),
                                    _: 1 /* STABLE */
                                })
                            ]),
                            _: 1 /* STABLE */
                        }, 8 /* PROPS */, ["model"]),
                        _createVNode(_unref(JButton), {
                            loading: saveHistoryLoading.value,
                            type: "primary",
                            class: "save-btn",
                            style: { "width": "100%" },
                            onClick: saveHistory
                        }, {
                            default: _withCtx(() => [
                                _createTextVNode(" 保存 ")
                            ]),
                            _: 1 /* STABLE */
                        }, 8 /* PROPS */, ["loading"])
                    ])
                ]),
                default: _withCtx(() => [
                    _createVNode(_unref(JButton), {
                        ghost: "",
                        type: "primary"
                    }, {
                        default: _withCtx(() => [
                            _createTextVNode(" 保存 ")
                        ]),
                        _: 1 /* STABLE */
                    })
                ]),
                _: 1 /* STABLE */
            }, 8 /* PROPS */, ["visible"]));
        };
    }
});
export default __sfc_main__;