/* Analyzed bindings: {
  "target": "props",
  "request": "props",
  "deleteRequest": "props",
  "deleteKey": "props",
  "computed": "setup-const",
  "ref": "setup-const",
  "isFunction": "setup-maybe-ref",
  "JMenu": "setup-maybe-ref",
  "JMenuItem": "setup-maybe-ref",
  "AIcon": "setup-maybe-ref",
  "JEmpty": "setup-maybe-ref",
  "JPopconfirm": "setup-maybe-ref",
  "Dropdown": "setup-maybe-ref",
  "Button": "setup-maybe-ref",
  "Input": "setup-maybe-ref",
  "FormItemRest": "setup-maybe-ref",
  "Popover": "setup-maybe-ref",
  "Ellipsis": "setup-maybe-ref",
  "message": "setup-maybe-ref",
  "emit": "setup-const",
  "props": "setup-reactive-const",
  "historyList": "setup-ref",
  "historyVisible": "setup-ref",
  "showEmpty": "setup-maybe-ref",
  "showHistoryList": "setup-const",
  "visibleChange": "setup-const",
  "click": "setup-const",
  "itemClick": "setup-const",
  "deleteHistory": "setup-const"
} */
import { defineComponent as _defineComponent } from 'vue';
import { createTextVNode as _createTextVNode, unref as _unref, withCtx as _withCtx, createVNode as _createVNode, renderList as _renderList, Fragment as _Fragment, openBlock as _openBlock, createElementBlock as _createElementBlock, toDisplayString as _toDisplayString, createElementVNode as _createElementVNode, withModifiers as _withModifiers } from "vue";
const _hoisted_1 = { class: "search-history-warp" };
const _hoisted_2 = {
    key: 0,
    class: "search-history-items"
};
const _hoisted_3 = ["onClick"];
const _hoisted_4 = { class: "delete" };
const _hoisted_5 = {
    key: 1,
    class: "search-history-empty"
};
const _hoisted_6 = ["onClick"];
import { computed, ref } from 'vue';
import { isFunction } from 'lodash-es';
import { AIcon, Empty as JEmpty, Popconfirm as JPopconfirm, Button, FormItemRest, Popover, Ellipsis, message, } from '../../components';
const __sfc_main__ = /*#__PURE__*/ _defineComponent({
    props: {
        target: {
            type: String,
            default: '',
            required: true,
        },
        request: {
            type: Function,
            default: null,
        },
        deleteRequest: {
            type: Function,
            default: null,
        },
        deleteKey: {
            type: String,
            default: 'key',
        },
    },
    emits: ["click", "itemClick"],
    setup(__props, { emit }) {
        const props = __props;
        const historyList = ref([]);
        const historyVisible = ref(false);
        const showEmpty = computed(() => {
            return historyList.value.length === 0;
        });
        const showHistoryList = async () => {
            if (props.request) {
                const resp = await props.request(props.target);
                if (resp.success && resp.result.length) {
                    historyList.value = resp.result.filter((item) => item.content);
                }
                else {
                    historyList.value = [];
                }
            }
        };
        const visibleChange = async (v) => {
            historyVisible.value = v;
        };
        const click = () => {
            emit('click');
        };
        const itemClick = (content) => {
            historyVisible.value = false;
            emit('itemClick', content);
        };
        const deleteHistory = async (item) => {
            if (props.deleteRequest && isFunction(props.deleteRequest)) {
                const resp = await props.deleteRequest(props.target, item[props.deleteKey]);
                historyVisible.value = false;
                if (resp.success || resp.status === 200 || resp.code === 200) {
                    message.success('操作成功');
                }
                else {
                    message.error('操作失败');
                }
            }
        };
        return (_ctx, _cache) => {
            return (_openBlock(), _createElementBlock("div", _hoisted_1, [
                _createVNode(_unref(FormItemRest), null, {
                    default: _withCtx(() => [
                        _createVNode(_unref(Button), {
                            class: "search-history-button",
                            type: "primary",
                            "html-type": "submit"
                        }, {
                            default: _withCtx(() => [
                                _createTextVNode(" 搜索 ")
                            ]),
                            _: 1 /* STABLE */
                        })
                    ]),
                    _: 1 /* STABLE */
                }),
                _createVNode(_unref(Popover), {
                    placement: "bottom",
                    trigger: "click",
                    "overlay-class-name": "search-history-list-pop",
                    visible: historyVisible.value,
                    onVisibleChange: visibleChange
                }, {
                    content: _withCtx(() => [
                        (!_unref(showEmpty))
                            ? (_openBlock(), _createElementBlock("div", _hoisted_2, [
                                (_openBlock(true), _createElementBlock(_Fragment, null, _renderList(historyList.value, (item) => {
                                    return (_openBlock(), _createElementBlock("div", {
                                        key: item.id,
                                        class: "search-history-item"
                                    }, [
                                        _createElementVNode("div", {
                                            class: "history-item--title",
                                            onClick: ($event) => (itemClick(item.content))
                                        }, [
                                            _createVNode(_unref(Ellipsis), { style: { "width": "100%" } }, {
                                                default: _withCtx(() => [
                                                    _createTextVNode(_toDisplayString(item.name), 1 /* TEXT */)
                                                ]),
                                                _: 2 /* DYNAMIC */
                                            }, 1024 /* DYNAMIC_SLOTS */)
                                        ], 8 /* PROPS */, _hoisted_3),
                                        _createVNode(_unref(JPopconfirm), {
                                            title: "确认删除吗？",
                                            placement: "top",
                                            onConfirm: ($event) => (deleteHistory(item))
                                        }, {
                                            default: _withCtx(() => [
                                                _createElementVNode("span", _hoisted_4, [
                                                    _createVNode(_unref(AIcon), { type: "DeleteOutlined" })
                                                ])
                                            ]),
                                            _: 2 /* DYNAMIC */
                                        }, 1032 /* PROPS, DYNAMIC_SLOTS */, ["onConfirm"])
                                    ]));
                                }), 128 /* KEYED_FRAGMENT */))
                            ]))
                            : (_openBlock(), _createElementBlock("div", _hoisted_5, [
                                _createVNode(_unref(JEmpty))
                            ]))
                    ]),
                    default: _withCtx(() => [
                        _createElementVNode("div", {
                            class: "search-history-button-icon",
                            onClick: _withModifiers(showHistoryList, ["stop"])
                        }, [
                            _createVNode(_unref(AIcon), { type: "DownOutlined" })
                        ], 8 /* PROPS */, _hoisted_6)
                    ]),
                    _: 1 /* STABLE */
                }, 8 /* PROPS */, ["visible"])
            ]));
        };
    }
});
export default __sfc_main__;