/* Analyzed bindings: {
  "isShowContent": "setup-maybe-ref",
  "Pagination": "setup-maybe-ref",
  "computed": "setup-const",
  "reactive": "setup-const",
  "paginationProps": "setup-maybe-ref",
  "omit": "setup-maybe-ref",
  "props": "setup-reactive-const",
  "baseProps": "setup-maybe-ref",
  "className": "setup-maybe-ref"
} */
import { defineComponent as _defineComponent } from 'vue';
import { unref as _unref, mergeProps as _mergeProps, openBlock as _openBlock, createBlock as _createBlock } from "vue";
import { Pagination } from 'ant-design-vue';
import { computed, reactive } from 'vue';
import { paginationProps } from 'ant-design-vue/lib/pagination';
import { omit } from 'lodash';
const __sfc_main__ = /*#__PURE__*/ _defineComponent({
    props: {
        ...paginationProps(),
        /**
         *  是否显示分页内容
         */
        isShowContent: {
            type: Boolean,
            default: false,
        },
    },
    setup(__props) {
        const props = __props;
        const baseProps = omit(props, ['isShowContent']);
        const { isShowContent } = reactive(props);
        const className = computed(() => {
            return {
                'show-content': !isShowContent,
            };
        });
        return (_ctx, _cache) => {
            return (_openBlock(), _createBlock(_unref(Pagination), _mergeProps(props, { class: _unref(className) }), null, 16 /* FULL_PROPS */, ["class"]));
        };
    }
});
export default __sfc_main__;