/* Analyzed bindings: {
  "iconDanger": "props",
  "myIcon": "props",
  "Button": "setup-maybe-ref",
  "AIcon": "setup-maybe-ref",
  "buttonProps": "setup-maybe-ref",
  "computed": "setup-const",
  "props": "setup-reactive-const",
  "className": "setup-maybe-ref"
} */
import { defineComponent as _defineComponent } from 'vue';
import { unref as _unref, openBlock as _openBlock, createBlock as _createBlock, createCommentVNode as _createCommentVNode, renderSlot as _renderSlot, mergeProps as _mergeProps, withCtx as _withCtx } from "vue";
import { Button } from 'ant-design-vue';
import { AIcon } from '../components';
import { buttonProps } from 'ant-design-vue/lib/button/buttonTypes';
import { computed } from 'vue';
const __default__ = {
    __ANT_BUTTON: true,
};
const __sfc_main__ = /*#__PURE__*/ _defineComponent({
    ...__default__,
    props: {
        ...buttonProps(),
        iconDanger: {
            type: Boolean,
            default: false,
        },
        myIcon: {
            type: String,
            default: '',
        },
    },
    setup(__props) {
        const props = __props;
        const className = computed(() => {
            return {
                'custom-button': true,
                'stroke-btn': String(props.type) === 'stroke',
                'icon-danger': String(props.type) === 'icon-danger',
            };
        });
        return (_ctx, _cache) => {
            return (_openBlock(), _createBlock(_unref(Button), _mergeProps(props, {
                class: [_unref(className)]
            }), {
                default: _withCtx(() => [
                    (props.myIcon)
                        ? (_openBlock(), _createBlock(_unref(AIcon), {
                            key: 0,
                            type: props.myIcon
                        }, null, 8 /* PROPS */, ["type"]))
                        : _createCommentVNode("v-if", true),
                    _renderSlot(_ctx.$slots, "icon"),
                    _renderSlot(_ctx.$slots, "default")
                ]),
                _: 3 /* FORWARDED */
            }, 16 /* FULL_PROPS */, ["class"]));
        };
    }
});
export default __sfc_main__;