import { cloneDeep } from 'lodash-es';
/**
 * 筛选树形结构
 * @param data 树形数据数组
 * @param filter 过滤参数值
 * @param filterType 过滤参数名
 * @returns 过滤后树形结构
 */
export function treeFilter(data, filter) {
  var filterType = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'title';
  var _data = cloneDeep(data);
  var traverse = function traverse(item) {
    item.forEach(function (child) {
      var _child$children;
      child.visible = filterMethod(filter, child, filterType);
      if (child.children) {
        traverse(child.children);
      }
      if (!child.visible && (_child$children = child.children) !== null && _child$children !== void 0 && _child$children.length) {
        child.visible = child.children.some(function (c) {
          return c.visible;
        });
      }
    });
  };
  traverse(_data);
  return filterDataByVisible(_data);
}
// 根据传入的值进行数据匹配, 并返回匹配结果
function filterMethod(val, data, filterType) {
  return data[filterType].includes(val);
}
// 递归过滤符合条件的数据
function filterDataByVisible(data) {
  return data.filter(function (item) {
    if (item.children) {
      item.children = filterDataByVisible(item.children);
    }
    return item.visible;
  });
}