import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";
import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import { resolveDirective as _resolveDirective, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
import _regeneratorRuntime from "@babel/runtime/regenerator";
import { Table, Empty, Pagination, AIcon, Button, Alert, Spin, RadioGroup, RadioButton } from '../../../components';
import { defineComponent, onMounted, onUnmounted, ref, watch } from 'vue';
import { ModelEnum } from '../proTableTypes';
import { get, debounce } from 'lodash-es';
import { tableProps as _tableProps } from "ant-design-vue/es/table";
var tableProps = function tableProps() {
  return _objectSpread(_objectSpread({}, _tableProps()), {}, {
    loading: {
      type: Boolean,
      default: undefined
    },
    request: {
      type: Function,
      default: undefined
    },
    cardBodyClass: {
      type: String,
      default: ''
    },
    bodyStyle: {
      type: Object,
      default: {}
    },
    columns: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    model: {
      type: [String, undefined],
      default: undefined
    },
    noPagination: {
      type: Boolean,
      default: false
    },
    rowSelection: {
      type: Object,
      default: function _default() {
        return undefined;
      }
    },
    dataSource: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    gridColumns: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    gridColumn: {
      type: Number,
      default: 4
    },
    alertRender: {
      type: Boolean,
      default: true
    },
    params: {
      type: Object,
      default: function _default() {}
    },
    type: {
      type: String,
      default: 'PAGE'
    },
    scroll: {
      type: Object,
      default: function _default() {
        x: 1366;
      }
    },
    defaultParams: {
      type: Object,
      default: function _default() {}
    },
    rowKey: {
      type: [String, Function],
      default: 'id'
    },
    pagination: {
      type: Object,
      default: function _default() {
        return {
          showSizeChanger: true,
          showQuickJumper: false,
          size: 'size',
          pageSizeOptions: ['12', '24', '48', '96']
        };
      }
    }
  });
};
var ProTable = defineComponent({
  name: 'ProTable',
  slots: ['headerTitle', 'card', 'rightExtraRender', 'paginationRender' // 分页
  ],

  props: tableProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      expose = _ref.expose;
    var _model = ref(props.model ? props.model : ModelEnum.CARD); // 模式切换
    var _dataSource = ref([]);
    var pageIndex = ref(0);
    var pageSize = ref(6);
    var total = ref(0);
    var _loading = ref(false);
    var column = ref(props.gridColumn || 4);
    /**
     * 监听宽度，计算显示卡片个数
     */
    var windowChange = function windowChange() {
      if (window.innerWidth <= 1440) {
        var _props$gridColumns;
        var _column = props.gridColumn && props.gridColumn < 2 ? props.gridColumn : 2;
        column.value = (_props$gridColumns = props.gridColumns) !== null && _props$gridColumns !== void 0 && _props$gridColumns[0] ? props.gridColumns[0] : _column;
      } else if (window.innerWidth > 1440 && window.innerWidth <= 1600) {
        var _props$gridColumns2;
        var _column2 = props.gridColumn && props.gridColumn < 3 ? props.gridColumn : 3;
        column.value = (_props$gridColumns2 = props.gridColumns) !== null && _props$gridColumns2 !== void 0 && _props$gridColumns2[1] ? props.gridColumns[1] : _column2;
      } else if (window.innerWidth > 1600) {
        var _props$gridColumns3;
        var _column3 = props.gridColumn && props.gridColumn < 4 ? props.gridColumn : 4;
        column.value = (_props$gridColumns3 = props.gridColumns) !== null && _props$gridColumns3 !== void 0 && _props$gridColumns3[2] ? props.gridColumns[2] : _column3;
      }
    };
    var handleSearch = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_params) {
        var _props$defaultParams, resp, _resp$result, _resp$result2, _resp$result3, _resp$result4, _resp$result4$data, _resp$result5, _resp$result6, _resp$result7, _resp$result8;
        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _loading.value = props.loading !== undefined ? props.loading : true;
              if (!props.request) {
                _context.next = 8;
                break;
              }
              _context.next = 4;
              return props.request(_objectSpread(_objectSpread(_objectSpread({
                pageIndex: 0,
                pageSize: 12
              }, props.defaultParams), _params), {}, {
                terms: [].concat(_toConsumableArray(((_props$defaultParams = props.defaultParams) === null || _props$defaultParams === void 0 ? void 0 : _props$defaultParams.terms) || []), _toConsumableArray((_params === null || _params === void 0 ? void 0 : _params.terms) || []))
              })).catch(function () {
                _loading.value = props.loading !== undefined ? props.loading : false;
              });
            case 4:
              resp = _context.sent;
              if (resp.status === 200) {
                if (props.type === 'PAGE') {
                  // 判断如果是最后一页且最后一页为空，就跳转到前一页
                  if (resp !== null && resp !== void 0 && (_resp$result = resp.result) !== null && _resp$result !== void 0 && _resp$result.total && resp !== null && resp !== void 0 && (_resp$result2 = resp.result) !== null && _resp$result2 !== void 0 && _resp$result2.pageSize && resp !== null && resp !== void 0 && (_resp$result3 = resp.result) !== null && _resp$result3 !== void 0 && _resp$result3.pageIndex && (resp === null || resp === void 0 ? void 0 : (_resp$result4 = resp.result) === null || _resp$result4 === void 0 ? void 0 : (_resp$result4$data = _resp$result4.data) === null || _resp$result4$data === void 0 ? void 0 : _resp$result4$data.length) === 0) {
                    handleSearch(_objectSpread(_objectSpread({}, _params), {}, {
                      pageSize: pageSize.value,
                      pageIndex: pageIndex.value > 0 ? pageIndex.value - 1 : 0
                    }));
                  } else {
                    _dataSource.value = (resp === null || resp === void 0 ? void 0 : (_resp$result5 = resp.result) === null || _resp$result5 === void 0 ? void 0 : _resp$result5.data) || [];
                    pageIndex.value = (resp === null || resp === void 0 ? void 0 : (_resp$result6 = resp.result) === null || _resp$result6 === void 0 ? void 0 : _resp$result6.pageIndex) || 0;
                    pageSize.value = (resp === null || resp === void 0 ? void 0 : (_resp$result7 = resp.result) === null || _resp$result7 === void 0 ? void 0 : _resp$result7.pageSize) || 6;
                    total.value = (resp === null || resp === void 0 ? void 0 : (_resp$result8 = resp.result) === null || _resp$result8 === void 0 ? void 0 : _resp$result8.total) || 0;
                  }
                } else {
                  _dataSource.value = (resp === null || resp === void 0 ? void 0 : resp.result) || [];
                }
              } else {
                _dataSource.value = [];
              }
              _context.next = 9;
              break;
            case 8:
              _dataSource.value = (props === null || props === void 0 ? void 0 : props.dataSource) || [];
            case 9:
              _loading.value = props.loading !== undefined ? props.loading : false;
            case 10:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return function handleSearch(_x) {
        return _ref2.apply(this, arguments);
      };
    }();
    var _debounceFn = debounce(handleSearch, 300);
    watch(function () {
      return props.params;
    }, function (newValue) {
      console.log('请求参数---params', new Date().getTime());
      _debounceFn(newValue || {});
    }, {
      deep: true,
      immediate: true
    });
    watch(function () {
      return props.dataSource;
    }, function (newVal) {
      if (newVal && !props.request) {
        handleSearch(props.params);
      }
    }, {
      deep: true,
      immediate: true
    });
    /**
     * 刷新数据
     * @param _params
     */
    var reload = function reload(_params) {
      handleSearch(_objectSpread(_objectSpread(_objectSpread({}, props.params), _params), {}, {
        pageSize: pageSize.value || 12,
        pageIndex: pageIndex.value || 0
      }));
    };
    onMounted(function () {
      windowChange(); // 初始化
      window.onresize = function () {
        windowChange();
      };
    });
    onUnmounted(function () {
      window.onresize = null;
    });
    /**
     * 导出方法
     */
    expose({
      reload: reload,
      _dataSource: _dataSource
    });
    return function () {
      var _props$rowSelection, _props$rowSelection$s, _props$rowSelection2, _props$rowSelection2$;
      return _createVNode("div", {
        "class": "jtable-body-spin",
        "style": _objectSpread({}, props.bodyStyle)
      }, [_createVNode(Spin, {
        "spinning": _loading.value
      }, {
        default: function _default() {
          return [_createVNode("div", {
            "class": 'jtable-body'
          }, [_createVNode("div", {
            "class": 'jtable-body-header'
          }, [_createVNode("div", {
            "class": 'jtable-body-header-left'
          }, [slots.headerTitle && slots.headerTitle()]), _createVNode("div", {
            "class": 'jtable-body-header-right'
          }, [slots.rightExtraRender && slots.rightExtraRender(), !props.model && _createVNode("div", {
            "class": 'jtable-body-header-right-button'
          }, [_createVNode(RadioGroup, {
            "class": "jtable-body-header-right-button",
            "value": _model.value,
            "onChange": function onChange(e) {
              _model.value = e.target.value;
            }
          }, {
            default: function _default() {
              return [_createVNode(RadioButton, {
                "value": ModelEnum.TABLE
              }, {
                default: function _default() {
                  return [_createVNode(AIcon, {
                    "class": 'right-button-icon',
                    "type": "UnorderedListOutlined"
                  }, null)];
                }
              }), _createVNode(RadioButton, {
                "value": ModelEnum.CARD
              }, {
                default: function _default() {
                  return [_createVNode(AIcon, {
                    "class": 'right-button-icon',
                    "type": "AppstoreOutlined"
                  }, null)];
                }
              })];
            }
          })])])]), _createVNode("div", {
            "class": 'jtable-content'
          }, [props.alertRender && props !== null && props !== void 0 && props.rowSelection && props !== null && props !== void 0 && (_props$rowSelection = props.rowSelection) !== null && _props$rowSelection !== void 0 && _props$rowSelection.selectedRowKeys && (_props$rowSelection$s = props.rowSelection.selectedRowKeys) !== null && _props$rowSelection$s !== void 0 && _props$rowSelection$s.length ? _createVNode("div", {
            "class": 'jtable-alert'
          }, [_createVNode(Alert, {
            "message": '已选择' + (props === null || props === void 0 ? void 0 : (_props$rowSelection2 = props.rowSelection) === null || _props$rowSelection2 === void 0 ? void 0 : (_props$rowSelection2$ = _props$rowSelection2.selectedRowKeys) === null || _props$rowSelection2$ === void 0 ? void 0 : _props$rowSelection2$.length) + '项',
            "type": "info",
            "onClose": function onClose() {
              var _props$rowSelection3;
              if ((_props$rowSelection3 = props.rowSelection) !== null && _props$rowSelection3 !== void 0 && _props$rowSelection3.onChange) {
                // 取消选择清空被选数据
                props.rowSelection.onChange([], []);
              }
            },
            "closeText": _createVNode(Button, {
              "type": "link"
            }, {
              default: function _default() {
                return [_createTextVNode("\u53D6\u6D88\u9009\u62E9")];
              }
            })
          }, null)]) : null, _model.value === ModelEnum.CARD ? _createVNode("div", {
            "class": 'jtable-card'
          }, [_dataSource.value.length ? _createVNode("div", {
            "class": 'jtable-card-items',
            "style": {
              gridTemplateColumns: "repeat(".concat(column.value, ", 1fr)")
            }
          }, [_dataSource.value.map(function (item) {
            return slots.card ? _createVNode("div", {
              "class": ['jtable-card-item', props.cardBodyClass]
            }, [slots.card(item)]) : null;
          })]) : _createVNode("div", {
            "class": "j-table-empty"
          }, [_createVNode(Empty, null, null)])]) : _createVNode("div", null, [_createVNode(Table, _objectSpread(_objectSpread({}, props), {}, {
            "dataSource": _dataSource.value,
            "columns": props.columns.filter(function (i) {
              return !(i !== null && i !== void 0 && i.hideInTable);
            }),
            "pagination": false,
            "rowSelection": props.rowSelection,
            "scroll": props.scroll
          }), {
            headerCell: function headerCell(dt) {
              var column = dt.column,
                title = dt.title;
              if (column !== null && column !== void 0 && column.headerCell) {
                return slots === null || slots === void 0 ? void 0 : slots[column === null || column === void 0 ? void 0 : column.headerCell](column.title);
              } else {
                return title || '';
              }
            },
            bodyCell: function bodyCell(dt) {
              var column = dt.column,
                record = dt.record;
              if ((column !== null && column !== void 0 && column.key || column !== null && column !== void 0 && column.dataIndex) && column !== null && column !== void 0 && column.scopedSlots && (slots !== null && slots !== void 0 && slots[column === null || column === void 0 ? void 0 : column.dataIndex] || slots !== null && slots !== void 0 && slots[column === null || column === void 0 ? void 0 : column.key])) {
                var _key = (column === null || column === void 0 ? void 0 : column.key) || (column === null || column === void 0 ? void 0 : column.dataIndex);
                return slots === null || slots === void 0 ? void 0 : slots[_key](record);
              } else {
                var _value = get(record, column === null || column === void 0 ? void 0 : column.dataIndex);
                // 获取数据
                return _value;
              }
            },
            emptyText: function emptyText() {
              return _createVNode(Empty, null, null);
            }
          })])]), !!_dataSource.value.length && !props.noPagination && props.type === 'PAGE' && _createVNode("div", {
            "class": 'jtable-pagination'
          }, [slots !== null && slots !== void 0 && slots.paginationRender ? slots.paginationRender() : _createVNode(Pagination, _objectSpread(_objectSpread({}, props.pagination), {}, {
            "total": total.value,
            "current": pageIndex.value + 1,
            "pageSize": pageSize.value,
            "showTotal": function showTotal(num) {
              var minSize = pageIndex.value * pageSize.value + 1;
              var MaxSize = (pageIndex.value + 1) * pageSize.value;
              return "\u7B2C ".concat(minSize, " - ").concat(MaxSize > num ? num : MaxSize, " \u6761/\u603B\u5171 ").concat(num, " \u6761");
            },
            "onChange": function onChange(page, size) {
              handleSearch(_objectSpread(_objectSpread({}, props.params), {}, {
                pageSize: size,
                pageIndex: pageSize.value === size ? page ? page - 1 : 0 : 0
              }));
            }
          }), null)])])];
        }
      })]);
    };
  }
});
export default ProTable;