import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/esm/objectWithoutProperties";
import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
var _excluded = ["rightContentRender"];
import { createVNode as _createVNode } from "vue";
import { computed, ref } from 'vue';
import { default as ResizeObserver } from "ant-design-vue/es/vc-resize-observer";
import { defaultRenderLogoAndTitle, siderMenuProps } from '../SiderMenu/SiderMenu';
import PropTypes from "ant-design-vue/es/_util/vue-types";
import { defaultSettingProps } from '../defaultSettings';
import { defaultPrefixCls, useRouteContext } from '../RouteContext';
import BaseMenu from '../SiderMenu/BaseMenu';
import { clearMenuItem } from '../util';
export var baseHeaderProps = _objectSpread(_objectSpread({}, defaultSettingProps), {}, {
  prefixCls: PropTypes.string.def('ant-pro'),
  collapsed: PropTypes.looseBool,
  logo: siderMenuProps.logo,
  logoStyle: siderMenuProps.logoStyle,
  headerTheme: {
    type: String,
    default: 'dark'
  },
  menuData: {
    type: Array,
    default: function _default() {
      return [];
    }
  },
  splitMenus: siderMenuProps.splitMenus,
  menuRender: {
    type: [Object, Function],
    default: function _default() {
      return undefined;
    }
  },
  menuHeaderRender: siderMenuProps.menuHeaderRender,
  menuItemRender: siderMenuProps.menuItemRender,
  subMenuItemRender: siderMenuProps.subMenuItemRender,
  rightContentRender: {
    type: [Object, Function],
    default: function _default() {
      return undefined;
    }
  },
  collapsedButtonRender: siderMenuProps.collapsedButtonRender,
  matchMenuKeys: siderMenuProps.matchMenuKeys,
  // events
  onMenuHeaderClick: PropTypes.func,
  onCollapse: siderMenuProps.onCollapse,
  onOpenKeys: siderMenuProps.onOpenKeys,
  onSelect: siderMenuProps.onSelect
});
export var topNavHeaderProps = _objectSpread(_objectSpread({}, siderMenuProps), baseHeaderProps);
var RightContent = function RightContent(_ref) {
  var rightContentRender = _ref.rightContentRender,
    props = _objectWithoutProperties(_ref, _excluded);
  var rightSize = ref('auto');
  return _createVNode("div", {
    "style": {
      minWidth: rightSize.value
    }
  }, [_createVNode("div", {
    "style": {
      paddingRight: 8
    }
  }, [_createVNode(ResizeObserver, {
    "onResize": function onResize(_ref2) {
      var width = _ref2.width;
      rightSize.value = width;
    }
  }, {
    default: function _default() {
      return [rightContentRender && typeof rightContentRender === 'function' ? _createVNode("div", null, [rightContentRender(_objectSpread({}, props))]) : rightContentRender];
    }
  })])]);
};
export var TopNavHeader = function TopNavHeader(props) {
  var headerRef = ref();
  var propPrefixCls = props.prefixCls,
    onMenuHeaderClick = props.onMenuHeaderClick,
    onOpenKeys = props.onOpenKeys,
    onSelect = props.onSelect,
    contentWidth = props.contentWidth,
    rightContentRender = props.rightContentRender,
    layout = props.layout,
    menuData = props.menuData,
    mode = props.mode;
  var context = useRouteContext();
  var prefixCls = "".concat(propPrefixCls || defaultPrefixCls, "-top-nav-header");
  var headerDom = defaultRenderLogoAndTitle(_objectSpread(_objectSpread({}, props), {}, {
    collapsed: false
  }),
  // REMARK:: Any time render header title
  // layout === 'mix' ? 'headerTitleRender' : undefined,
  // layout !== 'side' ? 'headerTitleRender' : undefined,
  'headerTitleRender');
  //
  var MenusData = props.layout === 'side' ? [] : menuData;
  if (props.layout === 'mix' && props.splitMenus) {
    var noChildrenMenuData = (menuData || []).map(function (item) {
      return _objectSpread(_objectSpread({}, item), {}, {
        children: undefined,
        component: undefined
      });
    });
    MenusData = clearMenuItem(noChildrenMenuData);
  }
  var _mode = computed(function () {
    return props.layout === 'mix' && props.splitMenus ? 'horizontal' : mode;
  });
  var className = computed(function () {
    var _ref3;
    return _ref3 = {}, _defineProperty(_ref3, prefixCls, true), _defineProperty(_ref3, "light", props.theme === 'light'), _defineProperty(_ref3, "dark", props.theme === 'dark'), _ref3;
  });
  return _createVNode("div", {
    "class": className.value
  }, [_createVNode("div", {
    "ref": headerRef,
    "class": "".concat(prefixCls, "-main ").concat(contentWidth === 'Fixed' ? 'wide' : '')
  }, [headerDom && _createVNode("div", {
    "class": "".concat(prefixCls, "-main-left"),
    "onClick": onMenuHeaderClick
  }, [_createVNode("div", {
    "class": "".concat(prefixCls, "-logo"),
    "key": "logo",
    "id": "logo"
  }, [headerDom])]), _createVNode("div", {
    "style": {
      flex: 1
    },
    "class": "".concat(prefixCls, "-menu")
  }, [_createVNode(BaseMenu, {
    "prefixCls": propPrefixCls,
    "locale": props.locale || context.locale,
    "theme": props.theme,
    "mode": _mode.value,
    "collapsed": props.collapsed,
    "iconfontUrl": props.iconfontUrl,
    "menuData": MenusData,
    "menuItemRender": props.menuItemRender,
    "subMenuItemRender": props.subMenuItemRender,
    "openKeys": context.openKeys,
    "selectedKeys": context.selectedKeys,
    "class": {
      'top-nav-menu': props.mode === 'horizontal'
    },
    'onUpdate:openKeys': function onUpdateOpenKeys($event) {
      return onOpenKeys && onOpenKeys($event);
    },
    'onUpdate:selectedKeys': function onUpdateSelectedKeys($event) {
      return onSelect && onSelect($event);
    }
  }, null)]), rightContentRender && _createVNode(RightContent, _objectSpread({
    "rightContentRender": rightContentRender
  }, props), null)])]);
};